/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.planets.nibiru.tileentity.TileEntityInfectedFurnace;
import stevekung.mods.moreplanets.planets.nibiru.tileentity.TileEntityTerrastoneFurnace;
import stevekung.mods.moreplanets.utils.blocks.BlockContainerMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityFurnaceMP;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;

public class BlockFurnaceMP
extends BlockContainerMP {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    private BlockType type;
    private static boolean keepInventory;

    public BlockFurnaceMP(String name, BlockType type) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c(name);
        this.func_149711_c(3.5f);
        this.type = type;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 13 : 0;
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.DECORATION_BLOCK;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (enumfacing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityFurnaceMP) {
            player.func_71007_a((IInventory)((TileEntityFurnaceMP)tileentity));
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.type == BlockType.INFECTED ? new TileEntityInfectedFurnace() : new TileEntityTerrastoneFurnace();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        TileEntity tileentity;
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 2);
        if (itemStack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFurnaceMP) {
            ((TileEntityFurnaceMP)tileentity).func_145951_a(itemStack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFurnaceMP) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityFurnaceMP)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperty.FACING_HORIZON, LIT});
    }

    public static void setState(BlockType type, boolean active, World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = type == BlockType.INFECTED ? MPBlocks.INFECTED_FURNACE : MPBlocks.TERRASTONE_FURNACE;
        keepInventory = true;
        if (active) {
            world.func_180501_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, iblockstate.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            world.func_180501_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, iblockstate.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, tileentity);
        }
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState block = world.func_180495_p(pos.func_177978_c());
            IBlockState block1 = world.func_180495_p(pos.func_177968_d());
            IBlockState block2 = world.func_180495_p(pos.func_177976_e());
            IBlockState block3 = world.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON);
            if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)enumfacing), 2);
        }
    }

    public static enum BlockType {
        INFECTED,
        TERRASTONE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

