/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.planets.chalos.world.gen.feature.WorldGenCheeseSporeTree;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenAlienBerryBigTree;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenAlienBerryTree;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedBigTree;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedDeadSpruce;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedJungleTrees;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedMegaJungleTree;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedMegaPineTree;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.feature.WorldGenInfectedTrees;
import stevekung.mods.moreplanets.utils.blocks.BlockBushMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;

public class BlockSaplingMP
extends BlockBushMP
implements IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    public static final PropertyBool NATURAL_GEN = PropertyBool.func_177716_a((String)"natural_gen");
    private BlockType type;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private static final AxisAlignedBB CHEESE_SPORE = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);

    public BlockSaplingMP(String name, BlockType type) {
        this.type = type;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NATURAL_GEN, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c(name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.type == BlockType.CHEESE_SPORE_FLOWER ? CHEESE_SPORE : AABB;
    }

    @Override
    protected boolean validBlock(Block block) {
        if (this.type == BlockType.ALIEN_BERRY_OAK_SAPLING) {
            return block == MPBlocks.GREEN_VEIN_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
        }
        if (this.type == BlockType.INFECTED_OAK_SAPLING || this.type == BlockType.INFECTED_JUNGLE_SAPLING || this.type == BlockType.INFECTED_SPRUCE_SAPLING) {
            return block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
        }
        if (this.type == BlockType.CHEESE_SPORE_FLOWER) {
            return block == MPBlocks.CHEESE_GRASS_BLOCK || block == MPBlocks.CHEESE_DIRT || block == MPBlocks.CHEESE_COARSE_DIRT || block == MPBlocks.CHEESE_FARMLAND;
        }
        return super.validBlock(block);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (!world.func_175697_a(pos, 1)) {
                return;
            }
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(world, rand, pos, state);
            }
        }
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.SAPLING;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (((Boolean)state.func_177229_b((IProperty)NATURAL_GEN)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)NATURAL_GEN, (Comparable)Boolean.valueOf(false)), 4);
        }
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < (this.type == BlockType.CHEESE_SPORE_FLOWER ? 0.25 : 0.45);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            Object worldGen = null;
            int i = 0;
            int j = 0;
            boolean flag = false;
            switch (this.type) {
                case INFECTED_OAK_SAPLING: {
                    worldGen = rand.nextInt(10) == 0 ? new WorldGenInfectedBigTree(true, MPBlocks.INFECTED_OAK_LOG.func_176223_P(), MPBlocks.INFECTED_OAK_LEAVES.func_176223_P()) : new WorldGenInfectedTrees(true, MPBlocks.INFECTED_OAK_LOG.func_176223_P(), MPBlocks.INFECTED_OAK_LEAVES.func_176223_P());
                    break;
                }
                case INFECTED_SPRUCE_SAPLING: {
                    block7: for (i = 0; i >= -1; --i) {
                        for (j = 0; j >= -1; --j) {
                            if (!this.isTwoByTwoOfType(world, pos, i, j, BlockType.INFECTED_SPRUCE_SAPLING)) continue;
                            worldGen = new WorldGenInfectedMegaPineTree(true, rand.nextBoolean());
                            flag = true;
                            break block7;
                        }
                    }
                    if (flag) break;
                    i = 0;
                    j = 0;
                    worldGen = new WorldGenInfectedDeadSpruce(true);
                    break;
                }
                case INFECTED_JUNGLE_SAPLING: {
                    block9: for (i = 0; i >= -1; --i) {
                        for (j = 0; j >= -1; --j) {
                            if (!this.isTwoByTwoOfType(world, pos, i, j, BlockType.INFECTED_JUNGLE_SAPLING)) continue;
                            worldGen = new WorldGenInfectedMegaJungleTree();
                            flag = true;
                            break block9;
                        }
                    }
                    if (flag) break;
                    j = 0;
                    i = 0;
                    worldGen = new WorldGenInfectedJungleTrees(true, 4 + rand.nextInt(7), false);
                    break;
                }
                case ALIEN_BERRY_OAK_SAPLING: {
                    worldGen = rand.nextInt(10) == 0 ? new WorldGenAlienBerryBigTree() : new WorldGenAlienBerryTree();
                    break;
                }
                case CHEESE_SPORE_FLOWER: {
                    if (((Boolean)state.func_177229_b((IProperty)NATURAL_GEN)).booleanValue()) break;
                    worldGen = new WorldGenCheeseSporeTree(6 + rand.nextInt(4), true);
                }
            }
            if (worldGen != null) {
                IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
                if (flag) {
                    world.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
                    world.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
                    world.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
                    world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
                } else {
                    world.func_180501_a(pos, iblockstate2, 4);
                }
                if (!worldGen.func_180709_b(world, rand, pos.func_177982_a(i, 0, j))) {
                    if (flag) {
                        world.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                        world.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                        world.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                        world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
                    } else {
                        world.func_180501_a(pos, state, 4);
                    }
                }
            }
        }
    }

    public Block.EnumOffsetType func_176218_Q() {
        return this.type == BlockType.CHEESE_SPORE_FLOWER ? Block.EnumOffsetType.XYZ : super.func_176218_Q();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta & 1)).func_177226_a((IProperty)NATURAL_GEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((Integer)state.func_177229_b((IProperty)STAGE)).intValue();
        if (!((Boolean)state.func_177229_b((IProperty)NATURAL_GEN)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE, NATURAL_GEN});
    }

    private boolean isTwoByTwoOfType(World world, BlockPos pos, int x, int z, BlockType type) {
        return this.isTypeAt(world, pos.func_177982_a(x, 0, z), type) && this.isTypeAt(world, pos.func_177982_a(x + 1, 0, z), type) && this.isTypeAt(world, pos.func_177982_a(x, 0, z + 1), type) && this.isTypeAt(world, pos.func_177982_a(x + 1, 0, z + 1), type);
    }

    private boolean isTypeAt(World world, BlockPos pos, BlockType type) {
        IBlockState iblockstate = world.func_180495_p(pos);
        return iblockstate.func_177230_c() == this && this.type == type;
    }

    public static enum BlockType {
        CHEESE_SPORE_FLOWER,
        INFECTED_OAK_SAPLING,
        INFECTED_SPRUCE_SAPLING,
        INFECTED_JUNGLE_SAPLING,
        ALIEN_BERRY_OAK_SAPLING;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

