/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.entity;

import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.utils.entity.ai.PathNavigateGroundMP;

public abstract class EntitySlimeBaseMP
extends EntityLiving
implements IMob,
IEntityBreathable {
    private static final DataParameter<Integer> SLIME_SIZE = EntityDataManager.func_187226_a(EntitySlimeBaseMP.class, (DataSerializer)DataSerializers.field_187192_b);
    protected float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public EntitySlimeBaseMP(World world) {
        super(world);
        this.field_70765_h = new SlimeMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)this, EntityIronGolem.class));
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateGroundMP(this, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLIME_SIZE, (Object)1);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Size", this.getSlimeSize() - 1);
        nbt.func_74757_a("wasOnGround", this.wasOnGround);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        int i = tagCompund.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSlimeSize(i + 1, false);
        this.wasOnGround = tagCompund.func_74767_n("wasOnGround");
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.func_70071_h_();
        if (this.field_70122_E && !this.wasOnGround) {
            this.createParticles();
            if (this.makesSoundOnLand()) {
                this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
    }

    public void func_184206_a(DataParameter key) {
        if (SLIME_SIZE.equals((Object)key)) {
            float i = this.getSizeBased() * (float)this.getSlimeSize();
            this.func_70105_a(i, i);
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(key);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntitySlimeBaseMP entityslime = this.createInstance();
                if (this.func_145818_k_()) {
                    entityslime.func_96094_a(this.func_95999_t());
                }
                if (this.func_104002_bU()) {
                    entityslime.func_110163_bv();
                }
                entityslime.setSlimeSize(i / 2, true);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        super.func_70106_y();
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (entity instanceof EntityIronGolem && this.canDamagePlayer()) {
            this.dealDamage((EntityLivingBase)entity);
        }
    }

    public void func_70100_b_(EntityPlayer entity) {
        if (this.canDamagePlayer()) {
            this.dealDamage((EntityLivingBase)entity);
        }
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return this.isSmallSlime() ? SoundEvents.field_187898_fy : SoundEvents.field_187880_fp;
    }

    protected SoundEvent func_184615_bR() {
        return this.isSmallSlime() ? SoundEvents.field_187896_fx : SoundEvents.field_187874_fm;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.42f;
        this.field_70160_al = true;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        int i = this.field_70146_Z.nextInt(3);
        if (i < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficulty.func_180170_c()) {
            ++i;
        }
        int j = 1 << i;
        this.setSlimeSize(j, true);
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean canBreath() {
        return true;
    }

    public void setSlimeSize(int size, boolean resetHealth) {
        this.field_70180_af.func_187227_b(SLIME_SIZE, (Object)size);
        float slimeSize = this.getSizeBased() * (float)size;
        this.func_70105_a(slimeSize, slimeSize);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.overrideHealth();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.2f + 0.1f * (float)size));
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = size;
    }

    public int getSlimeSize() {
        return (Integer)this.field_70180_af.func_187225_a(SLIME_SIZE);
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected void dealDamage(EntityLivingBase entity) {
        int i = this.getSlimeSize();
        if (this.func_70685_l((Entity)entity) && this.func_70068_e((Entity)entity) < this.getDetectRange() * (double)i * this.getDetectRange() * (double)i && entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
            this.func_174815_a((EntityLivingBase)this, (Entity)entity);
        }
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1 && !this.func_175446_cd();
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected float getSizeBased() {
        return 0.51000005f;
    }

    private SoundEvent getSquishSound() {
        return this.isSmallSlime() ? SoundEvents.field_187900_fz : SoundEvents.field_187886_fs;
    }

    private boolean isSmallSlime() {
        return this.getSlimeSize() <= 1;
    }

    private boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    private boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    private SoundEvent getJumpSound() {
        return this.isSmallSlime() ? MPSounds.SMALL_SLIME_JUMP : SoundEvents.field_187882_fq;
    }

    protected abstract double getDetectRange();

    protected abstract int getJumpDelay();

    protected abstract EntitySlimeBaseMP createInstance();

    protected abstract void createParticles();

    protected abstract void overrideHealth();

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntitySlimeBaseMP slime;
        private boolean isAggressive;

        public SlimeMoveHelper(EntitySlimeBaseMP slime) {
            super((EntityLiving)slime);
            this.slime = slime;
            this.yRot = 180.0f * slime.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean isAggressive) {
            this.yRot = yRot;
            this.isAggressive = isAggressive;
        }

        public void setSpeed(double speed) {
            this.field_75645_e = speed;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e(this.field_75648_a.func_175446_cd() ? 0.0f : (float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                        this.slime.func_70683_ar().func_75660_a();
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e(this.field_75648_a.func_175446_cd() ? 0.0f : (float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private EntitySlimeBaseMP slime;

        public AISlimeHop(EntitySlimeBaseMP slime) {
            this.slime = slime;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(this.slime.func_175446_cd() ? 0.0 : 1.0);
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private EntitySlimeBaseMP slime;

        public AISlimeFloat(EntitySlimeBaseMP slime) {
            this.slime = slime;
            this.func_75248_a(5);
            ((PathNavigateGroundMP)slime.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(this.slime.func_175446_cd() ? 0.0 : 1.2);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private EntitySlimeBaseMP slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISlimeFaceRandom(EntitySlimeBaseMP slime) {
            this.slime = slime;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private EntitySlimeBaseMP slime;
        private int growTieredTimer;

        public AISlimeAttack(EntitySlimeBaseMP slime) {
            this.slime = slime;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a ? false : --this.growTieredTimer > 0));
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }
}

