/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.BlockFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityFurnaceDouble
extends TileEntityInventoryBase
implements IButtonReactor {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1 = 1;
    public static final int SLOT_INPUT_2 = 2;
    public static final int SLOT_OUTPUT_2 = 3;
    public static final int ENERGY_USE = 25;
    private static final int SMELT_TIME = 80;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(30000, 150, 0);
    public int firstSmeltTime;
    public int secondSmeltTime;
    public boolean isAutoSplit;
    private int lastEnergy;
    private int lastFirstSmelt;
    private int lastSecondSmelt;
    private boolean lastAutoSplit;
    private boolean lastSmelted;

    public TileEntityFurnaceDouble() {
        super(4, "furnaceDouble");
    }

    public static void autoSplit(ItemStackHandlerAA inv, int slot1, int slot2) {
        ItemStack first = inv.getStackInSlot(slot1);
        ItemStack second = inv.getStackInSlot(slot2);
        if (StackUtil.isValid(first) || StackUtil.isValid(second)) {
            ItemStack toSplit = StackUtil.getEmpty();
            if (!StackUtil.isValid(first) && StackUtil.isValid(second) && second.func_190916_E() > 1) {
                toSplit = second;
            } else if (!StackUtil.isValid(second) && StackUtil.isValid(first) && first.func_190916_E() > 1) {
                toSplit = first;
            } else if (!(!ItemUtil.canBeStacked(first, second) || first.func_190916_E() >= first.func_77976_d() && second.func_190916_E() >= second.func_77976_d() || first.func_190916_E() <= second.func_190916_E() + 1 && first.func_190916_E() >= second.func_190916_E() - 1 || second.func_190916_E() <= first.func_190916_E() + 1 && second.func_190916_E() >= first.func_190916_E() - 1)) {
                toSplit = first;
                toSplit.func_190917_f(second.func_190916_E());
            }
            if (StackUtil.isValid(toSplit)) {
                ItemStack splitFirst = toSplit.func_77946_l();
                ItemStack secondSplit = splitFirst.func_77979_a(splitFirst.func_190916_E() / 2);
                inv.setStackInSlot(slot1, splitFirst);
                inv.setStackInSlot(slot2, secondSplit);
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("FirstSmeltTime", this.firstSmeltTime);
            compound.func_74768_a("SecondSmeltTime", this.secondSmeltTime);
            compound.func_74757_a("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstSmeltTime = compound.func_74762_e("FirstSmeltTime");
            this.secondSmeltTime = compound.func_74762_e("SecondSmeltTime");
            this.isAutoSplit = compound.func_74767_n("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean current;
            if (this.isAutoSplit) {
                TileEntityFurnaceDouble.autoSplit(this.inv, 0, 2);
            }
            boolean smelted = false;
            boolean canSmeltOnFirst = this.canSmeltOn(0, 1);
            boolean canSmeltOnSecond = this.canSmeltOn(2, 3);
            if (canSmeltOnFirst) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.firstSmeltTime;
                    if (this.firstSmeltTime >= 80) {
                        this.finishBurning(0, 1);
                        this.firstSmeltTime = 0;
                    }
                    this.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                this.firstSmeltTime = 0;
            }
            if (canSmeltOnSecond) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.secondSmeltTime;
                    if (this.secondSmeltTime >= 80) {
                        this.finishBurning(2, 3);
                        this.secondSmeltTime = 0;
                    }
                    this.storage.extractEnergyInternal(25, false);
                }
                smelted = true;
            } else {
                this.secondSmeltTime = 0;
            }
            IBlockState currState = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean changeTo = current = ((Boolean)currState.func_177229_b((IProperty)BlockFurnaceDouble.IS_ON)).booleanValue();
            if (this.lastSmelted != smelted) {
                changeTo = smelted;
            }
            if (this.isRedstonePowered) {
                changeTo = true;
            }
            if (!smelted && !this.isRedstonePowered) {
                changeTo = false;
            }
            if (changeTo != current) {
                this.field_145850_b.func_175656_a(this.field_174879_c, currState.func_177226_a((IProperty)BlockFurnaceDouble.IS_ON, (Comparable)Boolean.valueOf(changeTo)));
            }
            this.lastSmelted = smelted;
            if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstSmelt != this.firstSmeltTime || this.lastSecondSmelt != this.secondSmeltTime || this.isAutoSplit != this.lastAutoSplit) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastFirstSmelt = this.firstSmeltTime;
                this.lastAutoSplit = this.isAutoSplit;
                this.lastSecondSmelt = this.secondSmeltTime;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || (slot == 0 || slot == 2) && StackUtil.isValid(FurnaceRecipes.func_77602_a().func_151395_a(stack));
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || slot == 1 || slot == 3;
    }

    public boolean canSmeltOn(int theInput, int theOutput) {
        ItemStack output;
        return StackUtil.isValid(this.inv.getStackInSlot(theInput)) && StackUtil.isValid(output = FurnaceRecipes.func_77602_a().func_151395_a(this.inv.getStackInSlot(theInput))) && (!StackUtil.isValid(this.inv.getStackInSlot(theOutput)) || this.inv.getStackInSlot(theOutput).func_77969_a(output) && this.inv.getStackInSlot(theOutput).func_190916_E() <= this.inv.getStackInSlot(theOutput).func_77976_d() - output.func_190916_E());
    }

    public void finishBurning(int theInput, int theOutput) {
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(this.inv.getStackInSlot(theInput));
        if (!StackUtil.isValid(this.inv.getStackInSlot(theOutput))) {
            this.inv.setStackInSlot(theOutput, output.func_77946_l());
        } else if (this.inv.getStackInSlot(theOutput).func_77973_b() == output.func_77973_b()) {
            this.inv.getStackInSlot(theOutput).func_190917_f(output.func_190916_E());
        }
        this.inv.getStackInSlot(theInput).func_190918_g(1);
    }

    public int getFirstTimeToScale(int i) {
        return this.firstSmeltTime * i / 80;
    }

    public int getSecondTimeToScale(int i) {
        return this.secondSmeltTime * i / 80;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.func_70296_d();
        }
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

