/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.discordcraft.events;

import java.util.HashMap;
import mcjty.rftoolsdim.api.dimension.IDimensionInformation;
import me.dierke9.discordcraft.MinecraftRichPresence;
import me.dierke9.discordcraft.templates.IPresenceTemplate;
import me.dierke9.discordcraft.util.RFToolsDimensionManager;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="discordcraft", value={Side.CLIENT})
public class MainEventHandler {
    private RFToolsDimensionManager rfToolsDimensionManager;
    private Satellite satellite;

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity().equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            CelestialBody body;
            IPresenceTemplate processor = null;
            HashMap<String, String> arguments = new HashMap<String, String>();
            DimensionType dimType = e.getWorld().field_73011_w.func_186058_p();
            int dimId = e.getWorld().field_73011_w.getDimension();
            arguments.put("dimName", dimType.func_186065_b().replace('_', ' '));
            arguments.put("dimId", Integer.toString(dimId));
            if (MinecraftRichPresence.presence.getCurrentId() == dimId) {
                return;
            }
            if (Loader.isModLoaded((String)"rftoolsdim") && this.rfToolsDimensionManager.isRFToolsDimension(e.getWorld(), dimId)) {
                IDimensionInformation dimInfo = this.rfToolsDimensionManager.getDimensionInformation(e.getWorld(), dimId);
                arguments.put("rftools", dimInfo.getName());
                if (MinecraftRichPresence.templateManager.hasGroup("rftools")) {
                    processor = MinecraftRichPresence.templateManager.getGroup("rftools");
                }
            }
            if (Loader.isModLoaded((String)"galacticraftcore") && (body = GalaxyRegistry.getCelestialBodyFromDimensionID((int)dimType.func_186068_a())) != null) {
                switch (body.getClass().getSimpleName().toLowerCase()) {
                    case "planet": {
                        if (dimId == 0 || dimId == -1) break;
                        if (MinecraftRichPresence.templateManager.hasGroup("gcplanet")) {
                            processor = MinecraftRichPresence.templateManager.getGroup("gcplanet");
                        }
                        arguments.put("planet", body.getLocalizedName());
                        break;
                    }
                    case "moon": {
                        Moon moon = (Moon)body;
                        if (MinecraftRichPresence.templateManager.hasGroup("gcmoon")) {
                            processor = MinecraftRichPresence.templateManager.getGroup("gcmoon");
                        }
                        arguments.put("moon", body.getLocalizedName());
                        arguments.put("planet", moon.getParentPlanet().getLocalizedName());
                        break;
                    }
                    case "satellite": {
                        Satellite satellite;
                        if (MinecraftRichPresence.templateManager.hasGroup("gcsatellite")) {
                            processor = MinecraftRichPresence.templateManager.getGroup("gcsatellite");
                        }
                        String parent = (satellite = (Satellite)body).getParentPlanet().getUnlocalizedName().equalsIgnoreCase("planet.overworld") ? "Earth" : satellite.getParentPlanet().getUnlocalizedName();
                        SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)e.getWorld(), (int)dimId, (int)satellite.getParentPlanet().getID(), (int)satellite.getDimensionID(), (int)satellite.getDimensionIdStatic(), (EntityPlayer)((EntityPlayer)e.getEntity()));
                        arguments.put("planet", parent);
                        arguments.put("name", data.getSpaceStationName());
                    }
                }
            }
            if (processor == null && MinecraftRichPresence.templateManager.hasDim(dimType.func_186065_b())) {
                processor = MinecraftRichPresence.templateManager.getDim(dimType.func_186065_b());
            }
            if (processor == null) {
                processor = MinecraftRichPresence.templateManager.getGroup("default");
            }
            MinecraftRichPresence.presence.setState(processor.generateDimLine(arguments));
            MinecraftRichPresence.presence.updatePresence();
            MinecraftRichPresence.presence.setCurrentId(dimId);
        }
    }

    @SubscribeEvent
    public void onConnect(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        String details;
        String string = details = e.isLocal() ? "Singleplayer" : "Multiplayer ";
        if (!e.isLocal() && MinecraftRichPresence.Config.showIp) {
            details = details + Minecraft.func_71410_x().func_147104_D().field_78845_b;
        }
        MinecraftRichPresence.presence.setDetails(details);
        MinecraftRichPresence.presence.setState("Connecting...");
        MinecraftRichPresence.presence.updatePresence();
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        MinecraftRichPresence.logger.info("Server Disconnect");
        MinecraftRichPresence.presence.setDetails("");
        MinecraftRichPresence.presence.setState("In Main menu");
        MinecraftRichPresence.presence.updatePresence();
        MinecraftRichPresence.presence.setCurrentId(-99999);
    }

    public void createDimManager() {
        if (Loader.isModLoaded((String)"rftoolsdim")) {
            this.rfToolsDimensionManager = new RFToolsDimensionManager();
        }
    }
}

