/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.entities;

import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class EntityCustomCargoRocket
extends EntityAutoRocket
implements IRocketType,
IWorldTransferCallback {
    public IRocketType.EnumRocketType rocketType;
    public float rumble;
    public FluidTank fluidTank = new FluidTank(10000);
    public String fluidName;

    public EntityCustomCargoRocket(World par1World) {
        super(par1World);
        this.func_70105_a(0.98f, 2.0f);
    }

    public EntityCustomCargoRocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.func_70105_a(0.98f, 2.0f);
    }

    public int getFuelTankCapacity() {
        return 2000;
    }

    public float getCargoFilledAmount() {
        float weight = 1.0f;
        for (ItemStack stack : this.stacks) {
            if (stack == null || stack.func_190926_b()) continue;
            weight = (float)((double)weight + 0.1);
        }
        return weight;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(GSItems.ROCKET_FLUID_CRAGO, 1, this.rocketType.getIndex());
    }

    public void func_70071_h_() {
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            double motionScalar = this.timeSinceLaunch / 250.0f;
            motionScalar = Math.min(motionScalar, 1.0);
            double modifier = this.getCargoFilledAmount();
            if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && (motionScalar *= 5.0 / modifier) != 0.0) {
                this.field_70181_x = -motionScalar * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(3.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
        super.func_70071_h_();
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        }
        if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.fluidTank.getFluid() == null) {
            this.fluidTank.setFluid(new FluidStack(GSFluids.Helium3, 1535));
        }
    }

    protected boolean shouldMoveClientSide() {
        return true;
    }

    protected void spawnParticles(boolean launched) {
        double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
        double x1 = 2.0 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
        double z1 = 2.0 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
        double y1 = 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
            double modifier = this.field_70163_u - (double)this.targetVec.func_177956_o();
            modifier = Math.max(modifier, 1.0);
            x1 *= modifier / 60.0;
            y1 *= modifier / 60.0;
            z1 *= modifier / 60.0;
        }
        double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r) - 0.4;
        if (!this.field_70128_L) {
            EntityLivingBase riddenByEntity = this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityLivingBase) ? null : (EntityLivingBase)this.func_184188_bt().get(0);
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 - this.field_70146_Z.nextDouble() / 10.0 + x1, y, this.field_70161_v - 0.2 + this.field_70146_Z.nextDouble() / 10.0 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + 0.2 + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t - 0.2 + x1, y, this.field_70161_v + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v + 0.2 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle(this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle", new Vector3(this.field_70165_t + x1, y, this.field_70161_v - 0.2 + z1), new Vector3(x1, y1, z1), new Object[]{riddenByEntity});
        }
    }

    public void decodePacketdata(ByteBuf buffer) {
        this.rocketType = IRocketType.EnumRocketType.values()[buffer.readInt()];
        super.decodePacketdata(buffer);
        this.field_70165_t = buffer.readDouble() / 8000.0;
        this.field_70163_u = buffer.readDouble() / 8000.0;
        this.field_70161_v = buffer.readDouble() / 8000.0;
        FluidStack fluid = new FluidStack(GSFluids.Helium3, buffer.readInt());
        this.fluidTank.setFluid(fluid);
    }

    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        super.getNetworkedData(list);
        list.add(this.field_70165_t * 8000.0);
        list.add(this.field_70163_u * 8000.0);
        list.add(this.field_70161_v * 8000.0);
        list.add(this.fluidTank.getFluidAmount());
    }

    public void onReachAtmosphere() {
        if (this.field_70170_p.field_72995_K) {
            this.stopRocketSound();
            return;
        }
        GCLog.debug((String)("[Serverside] Cargo rocket reached space, heading to " + this.destinationFrequency));
        this.setTarget(true, this.destinationFrequency);
        if (this.targetVec != null) {
            GCLog.debug((String)("Destination location = " + this.targetVec.toString()));
            if (this.targetDimension != GCCoreUtil.getDimensionID((World)this.field_70170_p)) {
                GCLog.debug((String)("Destination is in different dimension: " + this.targetDimension));
                WorldProvider targetDim = WorldUtil.getProviderForDimensionServer((int)this.targetDimension);
                if (targetDim != null && targetDim.field_76579_a instanceof WorldServer) {
                    GCLog.debug((String)("Loaded destination dimension " + this.targetDimension));
                    this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
                    Entity e = WorldUtil.transferEntityToDimension((Entity)this, (int)this.targetDimension, (WorldServer)((WorldServer)targetDim.field_76579_a), (boolean)false, null);
                    if (e instanceof EntityCustomCargoRocket) {
                        GCLog.debug((String)"Cargo rocket arrived at destination dimension, going into landing mode.");
                        e.func_70107_b((double)((float)this.targetVec.func_177958_n() + 0.5f), (double)(this.targetVec.func_177956_o() + 800), (double)((float)this.targetVec.func_177952_p() + 0.5f));
                        ((EntityCustomCargoRocket)e).setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
                    } else {
                        GCLog.info((String)"Error: failed to recreate the cargo rocket in landing mode on target planet.");
                        e.func_70106_y();
                        this.func_70106_y();
                    }
                    return;
                }
                GCLog.info((String)"Error: the server failed to load the dimension the cargo rocket is supposed to land in. Destroying rocket!");
                this.func_70106_y();
                return;
            }
            GCLog.debug((String)"Cargo rocket going into landing mode in same destination.");
            this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
            this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
            return;
        }
        GCLog.info((String)"Error: the cargo rocket failed to find a valid landing spot when it reached space.");
        this.func_70106_y();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            player.func_145747_a((ITextComponent)new TextComponentString(this.fluidTank.getFluid().getLocalizedName() + ": " + this.fluidTank.getFluidAmount()));
        }
        return false;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        nbt.func_74768_a("Type", this.rocketType.getIndex());
        super.func_70014_b(nbt);
        if (this.fluidTank.getFluid() != null) {
            nbt.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbt.func_74775_l("fluidTank"));
        }
    }

    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        if (this.rocketType == null) {
            return 0;
        }
        return 0;
    }

    public void onWorldTransferred(World world) {
        if (this.targetVec != null) {
            this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
            this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
        } else {
            this.func_70106_y();
        }
    }

    public int getRocketTier() {
        return Integer.MAX_VALUE;
    }

    public int getPreLaunchWait() {
        return 20;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        super.getItemsDropped(droppedItemList);
        ItemStack rocket = new ItemStack(MarsItems.rocketMars, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItemList.add(rocket);
        return droppedItemList;
    }

    public boolean isPlayerRocket() {
        return false;
    }

    public double getOnPadYOffset() {
        return -0.05;
    }

    public float getRenderOffsetY() {
        return -0.1f;
    }
}

