/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.registers.fluids;

import galaxyspace.core.prefab.blocks.BlockFluidGS;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.systems.SolarSystem.moons.titan.blocks.BlockLiquidEthaneMethane;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class GSFluids {
    public static Fluid LiquidEthaneMethane;
    public static Fluid Helium3;
    public static Fluid Ethane;
    public static Fluid HeliumHydrogen;
    public static Block BLOCK_LEMETHANE;
    public static Block BLOCK_HELIUM3;
    public static Block BLOCK_ETHANE;
    public static Block BLOCK_HELIUM_HYDROGEN;
    public static final Material LEMethane;
    public static final Material HELIUM;
    public static final Material HH;

    public static void initialize() {
        LiquidEthaneMethane = GSFluids.registerFluid("liquidethanemethane", 1200, 140, 90, false, "liquid_ethanemethane");
        Helium3 = GSFluids.registerFluid("helium3", -1000, 1000, 0, true, "liquid_helium3");
        Ethane = GSFluids.registerFluid("ethane", -1000, 1000, 0, true, "liquid_ethane");
        HeliumHydrogen = GSFluids.registerFluid("heliumhydrogen", 1200, 140, 90, false, "liquid_heliumhydrogen");
        GalacticraftCore.proxy.registerFluidTexture(LiquidEthaneMethane, new ResourceLocation("galaxyspace", "textures/fluids/liquid_ethanemethane_still.png"));
        GSFluids.BlockFluidRegistration();
    }

    public static void BlockFluidRegistration() {
        BLOCK_LEMETHANE = new BlockLiquidEthaneMethane();
        BLOCK_HELIUM3 = new BlockFluidGS(Helium3, HELIUM, false);
        BLOCK_ETHANE = new BlockFluidGS(Ethane, HH, false);
        BLOCK_HELIUM_HYDROGEN = new BlockFluidGS(HeliumHydrogen, HH, false);
        GSBlocks.registerBlock(BLOCK_LEMETHANE, null);
        GSBlocks.registerBlock(BLOCK_HELIUM3, null);
        GSBlocks.registerBlock(BLOCK_ETHANE, null);
        GSBlocks.registerBlock(BLOCK_HELIUM_HYDROGEN, null);
    }

    private static Fluid registerFluid(String fluidName, int density, int viscosity, int temperature, boolean gaseous, String fluidTexture) {
        Fluid returnFluid = FluidRegistry.getFluid((String)fluidName);
        if (returnFluid == null) {
            ResourceLocation textureStill = new ResourceLocation("galaxyspace:fluids/" + fluidTexture + "_still");
            ResourceLocation textureFlowing = new ResourceLocation("galaxyspace:fluids/" + fluidTexture + "_flowing");
            FluidRegistry.registerFluid((Fluid)new Fluid(fluidName, textureStill, textureFlowing).setDensity(density).setViscosity(viscosity).setTemperature(temperature).setGaseous(gaseous));
            returnFluid = FluidRegistry.getFluid((String)fluidName);
            FluidRegistry.addBucketForFluid((Fluid)returnFluid);
        } else {
            returnFluid.setGaseous(gaseous);
        }
        return returnFluid;
    }

    static {
        LEMethane = new MaterialLiquid(MapColor.field_151650_B){

            public EnumPushReaction func_186274_m() {
                return EnumPushReaction.DESTROY;
            }
        };
        HELIUM = new MaterialLiquid(MapColor.field_151666_j){

            public EnumPushReaction func_186274_m() {
                return EnumPushReaction.DESTROY;
            }
        };
        HH = new MaterialLiquid(MapColor.field_151671_v){

            public EnumPushReaction func_186274_m() {
                return EnumPushReaction.DESTROY;
            }
        };
    }
}

