/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockRadiationStabiliser;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProviderColored;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRadiationStabiliser
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IBubbleProviderColored {
    public float bubbleSize;
    public static HashSet<BlockVec3Dim> loadedTiles = new HashSet();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRenderBubble = true;

    public TileEntityRadiationStabiliser() {
        super("tile.radiation_stabiliser.name");
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 45.0f);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim((TileEntity)this));
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim((TileEntity)this));
        }
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(new BlockVec3Dim((TileEntity)this));
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(new BlockVec3Dim((TileEntity)this));
        }
        super.func_145843_s();
    }

    public double getPacketRange() {
        return 64.0;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            if (this.field_145850_b.func_73046_m().func_71262_S()) {
                networkedList.add(loadedTiles.size());
                for (BlockVec3Dim distributor : loadedTiles) {
                    if (distributor == null) {
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        continue;
                    }
                    networkedList.add(distributor.x);
                    networkedList.add(distributor.y);
                    networkedList.add(distributor.z);
                    networkedList.add(distributor.dim);
                }
            } else {
                networkedList.add(-1);
            }
            networkedList.add(Float.valueOf(this.bubbleSize));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() - this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() - this.bubbleSize), (double)((float)this.func_174877_v().func_177958_n() + this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() + this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() + this.bubbleSize));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 261144.0;
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            int size = dataStream.readInt();
            if (size >= 0) {
                loadedTiles.clear();
                for (int i = 0; i < size; ++i) {
                    int i1 = dataStream.readInt();
                    int i2 = dataStream.readInt();
                    int i3 = dataStream.readInt();
                    int i4 = dataStream.readInt();
                    if (i1 == -1 && i2 == -1 && i3 == -1 && i4 == -1) continue;
                    loadedTiles.add(new BlockVec3Dim(i1, i2, i3, i4));
                }
            }
            this.bubbleSize = dataStream.readFloat();
        }
    }

    public int getDistanceFromServer(int par1, int par3, int par5) {
        int d3 = this.func_174877_v().func_177958_n() - par1;
        int d4 = this.func_174877_v().func_177956_o() - par3;
        int d5 = this.func_174877_v().func_177952_p() - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            int range_boost = 0;
            int energy_boost = 0;
            for (int i = 0; i <= 3; ++i) {
                if (((ItemStack)this.getInventory().get(1 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 0))) {
                    ++range_boost;
                }
                if (!((ItemStack)this.getInventory().get(1 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 3))) continue;
                ++energy_boost;
            }
            this.bubbleSize = this.getEnergyStoredGC() > 0.0f && this.hasEnoughEnergyToRun && !this.disabled ? (this.bubbleSize += 0.01f) : (this.bubbleSize -= 0.05f);
            this.bubbleSize = Math.min(Math.max(this.bubbleSize, 0.0f), 10.0f + 5.0f * (float)range_boost);
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? (float)(90 + 60 * range_boost - 20 * energy_boost) : (float)(45 + 45 * range_boost - 15 * energy_boost));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("bubbleVisible")) {
            this.setBubbleVisible(nbt.func_74767_n("bubbleVisible"));
        }
        if (nbt.func_74764_b("bubbleSize")) {
            this.bubbleSize = nbt.func_74760_g("bubbleSize");
        }
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.getInventory());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("bubbleVisible", this.shouldRenderBubble);
        nbt.func_74776_a("bubbleSize", this.bubbleSize);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.getInventory());
        return nbt;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemstack);
                }
                case 1: {
                    return itemstack.equals(new ItemStack(GSItems.BASIC, 1, 13));
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItemEmpty((ItemStack)itemstack);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
        }
        if (slotID == 1) {
            return itemstack.equals(new ItemStack(GSItems.BASIC, 1, 13));
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.hasEnoughEnergyToRun;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockRadiationStabiliser) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockRadiationStabiliser.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e().func_176746_e().func_176734_d();
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public boolean inBubble(double pX, double pY, double pZ) {
        double r = this.bubbleSize;
        r *= r;
        double d3 = (double)this.func_174877_v().func_177958_n() + 0.5 - pX;
        if ((d3 *= d3) > r) {
            return false;
        }
        double d4 = (double)this.func_174877_v().func_177952_p() + 0.5 - pZ;
        if (d3 + (d4 *= d4) > r) {
            return false;
        }
        double d5 = (double)this.func_174877_v().func_177956_o() + 0.5 - pY;
        return d3 + d4 + d5 * d5 < r;
    }

    public void setBubbleVisible(boolean shouldRender) {
        this.shouldRenderBubble = shouldRender;
    }

    public float getBubbleSize() {
        return this.bubbleSize;
    }

    public boolean getBubbleVisible() {
        return this.shouldRenderBubble;
    }

    public Vector3 getColor() {
        return new Vector3((double)0.45f, 0.0, (double)0.1f);
    }
}

