/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.module;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.squiddev.plethora.api.method.BasicMethod;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleMethod;

public abstract class ModuleContainerMethod
extends BasicMethod<IModuleContainer>
implements IModuleMethod<IModuleContainer> {
    private final Set<ResourceLocation> modules;

    public ModuleContainerMethod(String name, Set<ResourceLocation> modules, int priority, String doc) {
        super(name, priority, doc);
        Preconditions.checkArgument((!modules.isEmpty() ? 1 : 0) != 0, (Object)"modules must be non-empty");
        this.modules = modules;
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<IModuleContainer> context) {
        if (!super.canApply(context)) {
            return false;
        }
        IModuleContainer container = context.getTarget();
        for (ResourceLocation module : this.modules) {
            if (container.hasModule(module)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Collection<ResourceLocation> getModules() {
        return this.modules;
    }
}

