/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client.gui;

import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.shared.computer.core.IComputer;
import java.io.IOException;
import java.util.Collections;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.squiddev.plethora.gameplay.neural.ContainerNeuralInterface;
import org.squiddev.plethora.gameplay.neural.ItemComputerHandler;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.Vec2i;

public class GuiNeuralInterface
extends GuiContainer {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("plethora", "textures/gui/neural_interface.png");
    private static final int ICON_Y = 224;
    private final IComputer computer;
    private WidgetTerminal terminalGui;
    private final ContainerNeuralInterface container;
    private boolean peripherals = true;

    public GuiNeuralInterface(ContainerNeuralInterface container) {
        super((Container)container);
        this.container = container;
        this.computer = ItemComputerHandler.getClient(container.getStack());
        this.field_146999_f = 254;
        this.field_147000_g = 217;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.terminalGui = new WidgetTerminal((this.field_146294_l - this.field_146999_f) / 2 + 8, (this.field_146295_m - this.field_147000_g) / 2 + 8, 39, 13, () -> this.computer, 2, 2, 2, 2);
        this.terminalGui.setAllowFocusLoss(false);
        this.updateVisible();
    }

    public void func_146269_k() throws IOException {
        boolean previous = Keyboard.areRepeatEventsEnabled();
        if (!previous) {
            Keyboard.enableRepeatEvents((boolean)true);
        }
        super.func_146269_k();
        if (!previous) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.terminalGui.update();
    }

    protected void func_73869_a(char chr, int code) throws IOException {
        if (code == 1) {
            super.func_73869_a(chr, code);
        } else {
            this.keyHandled |= this.terminalGui.onKeyTyped(chr, code);
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.terminalGui.mouseClicked(x, y, button);
        int ox = x - this.field_147003_i;
        int oy = y - this.field_147009_r;
        if (ox >= ContainerNeuralInterface.SWAP.x && ox < ContainerNeuralInterface.SWAP.x + 16 && oy >= ContainerNeuralInterface.SWAP.y && oy < ContainerNeuralInterface.SWAP.y + 16) {
            this.peripherals = !this.peripherals;
            this.updateVisible();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.terminalGui.handleMouseInput(x, y);
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        this.keyHandled |= this.terminalGui.onKeyboardInput();
    }

    protected void func_146976_a(float v, int mouseX, int mouseY) {
        this.terminalGui.draw(this.field_146297_k, 0, 0, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.drawTexturedRect(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawTexturedRect(ContainerNeuralInterface.SWAP.x, ContainerNeuralInterface.SWAP.y, this.peripherals ? 0 : 16, 224, 16, 16);
        if (this.peripherals) {
            this.drawTexturedRect(204, 135, 32, 224, 16, 16);
            this.drawTexturedRect(186, 153, 50, 224, 48, 16);
            this.drawTexturedRect(204, 171, 104, 224, 16, 16);
        }
    }

    private void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, u, v, width, height);
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(x, y, partialTicks);
        int ox = x - this.field_147003_i;
        int oy = y - this.field_147009_r;
        if (ox >= ContainerNeuralInterface.SWAP.x && ox < ContainerNeuralInterface.SWAP.x + 16 && oy >= ContainerNeuralInterface.SWAP.y && oy < ContainerNeuralInterface.SWAP.y + 16) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(this.field_147003_i + ContainerNeuralInterface.SWAP.x, this.field_147009_r + ContainerNeuralInterface.SWAP.y, this.field_147003_i + ContainerNeuralInterface.SWAP.x + 16, this.field_147009_r + ContainerNeuralInterface.SWAP.y + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            this.func_146283_a(Collections.singletonList(Helpers.translateToLocal(this.peripherals ? "gui.plethora.neuralInterface.modules" : "gui.plethora.neuralInterface.peripherals")), x, y);
        }
        this.func_191948_b(x, y);
    }

    private void updateVisible() {
        GuiNeuralInterface.setVisible(this.container.peripheralSlots, this.peripherals);
        GuiNeuralInterface.setVisible(this.container.moduleSlots, !this.peripherals);
    }

    private static void setVisible(Slot[] slots, boolean visible) {
        int peripheralSlotsLength = slots.length;
        for (int i = 0; i < peripheralSlotsLength; ++i) {
            Slot slot = slots[i];
            if (visible) {
                Vec2i pos = ContainerNeuralInterface.POSITIONS[i];
                slot.field_75223_e = pos.x;
                slot.field_75221_f = pos.y;
                continue;
            }
            slot.field_75223_e = -2000;
            slot.field_75221_f = -2000;
        }
    }
}

