/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.minecart;

import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class MinecartHelpers {
    private static int[][][] matrix;

    private MinecartHelpers() {
    }

    private static int[][][] getMatrix() {
        if (matrix == null) {
            matrix = (int[][][])ObfuscationReflectionHelper.getPrivateValue(EntityMinecart.class, null, (String[])new String[]{"field_70500_g"});
        }
        return matrix;
    }

    public static Vec3d getPosOffset(EntityMinecart minecart, double x, double y, double z, double offset) {
        IBlockState block;
        int xf = MathHelper.func_76128_c((double)x);
        int yf = MathHelper.func_76128_c((double)y);
        int zf = MathHelper.func_76128_c((double)z);
        if (BlockRailBase.func_176562_d((World)minecart.func_130014_f_(), (BlockPos)new BlockPos(xf, yf - 1, zf))) {
            --yf;
        }
        if (BlockRailBase.func_176563_d((IBlockState)(block = minecart.func_130014_f_().func_180495_p(new BlockPos(xf, yf, zf))))) {
            BlockRailBase.EnumRailDirection railBase = ((BlockRailBase)block.func_177230_c()).getRailDirection((IBlockAccess)minecart.func_130014_f_(), new BlockPos(xf, yf, zf), block, minecart);
            y = yf;
            if (railBase.func_177018_c()) {
                y = yf + 1;
            }
            int[][] transformed = MinecartHelpers.getMatrix()[railBase.func_177015_a()];
            double dx = transformed[1][0] - transformed[0][0];
            double dz = transformed[1][2] - transformed[0][2];
            double len = Math.sqrt(dx * dx + dz * dz);
            if (transformed[0][1] != 0 && MathHelper.func_76128_c((double)(x += (dx /= len) * offset)) - xf == transformed[0][0] && MathHelper.func_76128_c((double)(z += (dz /= len) * offset)) - zf == transformed[0][2]) {
                y += (double)transformed[0][1];
            } else if (transformed[1][1] != 0 && MathHelper.func_76128_c((double)x) - xf == transformed[1][0] && MathHelper.func_76128_c((double)z) - zf == transformed[1][2]) {
                y += (double)transformed[1][1];
            }
            return minecart.func_70489_a(x, y, z);
        }
        return null;
    }
}

