/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.api.reference.ConstantReference;

public class EntityIdentifier
implements ConstantReference<EntityIdentifier> {
    private final UUID uuid;
    private final String name;

    EntityIdentifier(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public EntityIdentifier(Entity entity) {
        this.uuid = entity.getPersistentID();
        this.name = null;
    }

    @Nonnull
    public UUID getId() {
        return this.uuid;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public EntityIdentifier get() {
        return this;
    }

    @Override
    @Nonnull
    public EntityIdentifier safeGet() {
        return this;
    }

    public EntityLivingBase getEntity() throws LuaException {
        Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(this.getId());
        if (!(entity instanceof EntityLivingBase)) {
            throw new LuaException("Cannot find entity");
        }
        return (EntityLivingBase)entity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityIdentifier that = (EntityIdentifier)o;
        return this.uuid.equals(that.uuid) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return 31 * this.uuid.hashCode() + (this.name != null ? this.name.hashCode() : 0);
    }

    public static class Player
    extends EntityIdentifier
    implements IPlayerOwnable {
        private final GameProfile profile;

        public Player(GameProfile profile) {
            super(profile.getId(), profile.getName());
            this.profile = profile;
        }

        @Override
        public GameProfile getOwningProfile() {
            return this.profile;
        }

        public EntityPlayerMP getPlayer() throws LuaException {
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.profile.getId());
            if (player == null) {
                throw new LuaException("Player is not online");
            }
            return player;
        }
    }
}

