/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world.data;

import java.awt.Color;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.IChunkData;

public abstract class BaseChunkData
implements IChunkData {
    public int chunkX;
    public int chunkZ;
    public boolean slimeChunk;
    protected int[] heightMap = new int[256];

    protected BaseChunkData() {
    }

    public BaseChunkData(Chunk chunk) {
        this.chunkX = chunk.field_76635_g;
        this.chunkZ = chunk.field_76647_h;
        this.slimeChunk = chunk.func_76617_a(987234911L).nextInt(10) == 0;
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    @Override
    public int getHeight(int x, int z) {
        if (this.heightMap.length <= 0) {
            return -1;
        }
        return this.heightMap[z * 16 + x];
    }

    @Override
    public boolean isSlimeChunk() {
        return this.slimeChunk;
    }

    protected Biome getBiome(int biome) {
        return Biome.func_180276_a((int)biome, (Biome)Biomes.field_76772_c);
    }

    protected void getFirstBlock(Chunk chunk, BlockPos.MutableBlockPos pos) {
        IBlockState state = chunk.func_177435_g((BlockPos)pos);
        while (state.func_177230_c().isAir(state, (IBlockAccess)chunk.func_177412_p(), (BlockPos)pos) && pos.func_177956_o() > 0) {
            pos.func_189536_c(EnumFacing.DOWN);
            state = chunk.func_177435_g((BlockPos)pos);
        }
    }

    protected int getHeightMapHeight(Chunk chunk, BlockPos.MutableBlockPos pos) {
        IBlockState state = chunk.func_177435_g((BlockPos)pos);
        while (state.func_177230_c().isAir(state, (IBlockAccess)chunk.func_177412_p(), (BlockPos)pos) || !state.func_185904_a().func_76230_c()) {
            pos.func_189536_c(EnumFacing.DOWN);
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            state = chunk.func_177435_g((BlockPos)pos);
        }
        return pos.func_177956_o();
    }

    public static int darker(int color, float factor) {
        return BaseChunkData.darker(new Color(color), factor);
    }

    public static int darker(Color color, float factor) {
        return new Color(Math.max((int)((float)color.getRed() * factor), 0), Math.max((int)((float)color.getGreen() * factor), 0), Math.max((int)((float)color.getBlue() * factor), 0), color.getAlpha()).getRGB();
    }

    public static int brighter(int color, float factor) {
        return BaseChunkData.brighter(new Color(color), factor);
    }

    public static int brighter(Color color, float factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha).getRGB();
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / factor), 255), Math.min((int)((float)g / factor), 255), Math.min((int)((float)b / factor), 255), alpha).getRGB();
    }

    protected boolean isDarker(int x, int z, IHeightMap map) {
        int base = map.getHeight(x, z);
        return this.isEnoughSmaller(base, map.getHeight(x, z + 1, base)) || this.isEnoughSmaller(base, map.getHeight(x + 1, z, base));
    }

    protected boolean isBrigther(int x, int z, IHeightMap map) {
        int base = map.getHeight(x, z);
        return this.isEnoughBigger(base, map.getHeight(x + 1, z, base)) || this.isEnoughBigger(base, map.getHeight(x, z + 1, base));
    }

    protected boolean isEnoughBigger(int base, int other) {
        return base >= other ? false : other - base <= 3;
    }

    protected boolean isEnoughSmaller(int base, int other) {
        return base <= other ? false : base - other <= 3;
    }
}

