/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUVLightBox;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockUVLightBox
extends BlockPneumaticCraftModeled {
    private static final PropertyBool LOADED = PropertyBool.func_177716_a((String)"loaded");
    private static final AxisAlignedBB BLOCK_BOUNDS_NS = new AxisAlignedBB(0.0625, 0.0, 0.28125, 0.9375, 0.4375, 0.71875);
    private static final AxisAlignedBB BLOCK_BOUNDS_EW = new AxisAlignedBB(0.28125, 0.0, 0.0625, 0.71875, 0.4375, 0.9375);

    BlockUVLightBox() {
        super(Material.field_151573_f, "uv_light_box");
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, LOADED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntity te = PneumaticCraftUtils.getTileEntitySafely(worldIn, pos);
        if (te instanceof TileEntityUVLightBox) {
            state = state.func_177226_a((IProperty)LOADED, (Comparable)Boolean.valueOf(((TileEntityUVLightBox)te).hasLoadedPCB));
        }
        return state;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!source.func_180495_p(pos).func_177227_a().contains(ROTATION)) {
            return BLOCK_BOUNDS_EW;
        }
        EnumFacing facing = this.getRotation(source, pos);
        return facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? BLOCK_BOUNDS_NS : BLOCK_BOUNDS_EW;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, worldIn, pos);
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityUVLightBox.class;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.UV_LIGHT_BOX;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityUVLightBox ? ((TileEntityUVLightBox)te).getLightLevel() : 0;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof TileEntityUVLightBox) {
            return ((TileEntityUVLightBox)te).shouldEmitRedstone() ? 15 : 0;
        }
        return 0;
    }
}

