/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandlerPneumaticArmor {
    private static final Map<Integer, Integer> targetingTracker = new HashMap<Integer, Integer>();
    private static final Map<UUID, Long> armorJumping = new HashMap<UUID, Long>();
    private static final Vec3d IDLE_VEC = new Vec3d(0.0, -0.5, 0.0);

    @SubscribeEvent
    public void onMobTargetSet(LivingSetAttackTargetEvent event) {
        int mobId = event.getEntityLiving().func_145782_y();
        if (event.getTarget() instanceof EntityPlayerMP) {
            CommonArmorHandler handler;
            EntityPlayerMP player = (EntityPlayerMP)event.getTarget();
            if (ItemPneumaticArmor.isPneumaticArmorPiece((EntityPlayer)player, EntityEquipmentSlot.HEAD) && (!targetingTracker.containsKey(mobId) || targetingTracker.get(mobId).intValue() != event.getTarget().func_145782_y()) && (handler = CommonArmorHandler.getHandlerForPlayer((EntityPlayer)player)).isArmorReady(EntityEquipmentSlot.HEAD) && handler.getArmorPressure(EntityEquipmentSlot.HEAD) > 0.0f && handler.isEntityTrackerEnabled()) {
                NetworkHandler.sendTo(new PacketSendArmorHUDMessage("pneumaticHelmet.message.targetWarning", 60, 1895776256, event.getEntityLiving().func_70005_c_()), player);
            }
            targetingTracker.put(mobId, event.getTarget().func_145782_y());
        } else {
            targetingTracker.remove(mobId);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        targetingTracker.remove(event.getEntityLiving().func_145782_y());
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        long when = armorJumping.getOrDefault(player.func_110124_au(), 0L);
        if (player.field_70170_p.func_82737_E() - when < 40L) {
            event.setCanceled(true);
            return;
        }
        armorJumping.remove(player.func_110124_au());
        if (event.getDistance() > 3.0f) {
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (!handler.isArmorEnabled()) {
                return;
            }
            if (event.getEntity().field_70170_p.func_175659_aa() == EnumDifficulty.HARD && handler.isJetBootsActive()) {
                event.setDamageMultiplier(0.2f);
                return;
            }
            ItemPneumaticArmor boots = (ItemPneumaticArmor)stack.func_77973_b();
            float airNeeded = event.getDistance() * 20.0f;
            float airAvailable = (float)boots.getVolume(stack) * handler.getArmorPressure(EntityEquipmentSlot.FEET);
            if (airAvailable < 1.0f) {
                return;
            }
            if (airAvailable >= airNeeded) {
                event.setCanceled(true);
            } else {
                event.setDamageMultiplier(1.0f - airAvailable / airNeeded);
            }
            int i = 0;
            while ((float)i < event.getDistance() / 2.0f) {
                float sx = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                float sz = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)sx, 0.1, (double)sz), player.field_70170_p);
                ++i;
            }
            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.SHORT_HISS, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.3f, 0.8f, false), player.field_70170_p);
            handler.addAir(EntityEquipmentSlot.FEET, (int)(-airNeeded));
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            Minigun minigun;
            ItemStack stack;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (ItemPneumaticArmor.isPneumaticArmorPiece(player, EntityEquipmentSlot.CHEST) && event.getSource().func_76347_k()) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                if (handler.isArmorEnabled() && handler.getArmorPressure(EntityEquipmentSlot.CHEST) > 0.1f && handler.getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.SECURITY) > 0) {
                    event.setCanceled(true);
                    player.func_70066_B();
                    if (!player.field_70170_p.field_72995_K) {
                        handler.addAir(EntityEquipmentSlot.CHEST, -50);
                        for (int i = 0; i < 2; ++i) {
                            float sx = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                            float sz = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, player.field_70165_t + (double)sx, player.field_70163_u + 1.0, player.field_70161_v + (double)sz, (double)(sx / 4.0f), -0.2, (double)(sz / 4.0f)), player.field_70170_p);
                        }
                        if ((player.field_70173_aa & 0xF) == 0) {
                            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.LEAKING_GAS_SOUND, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 0.7f, false), player.field_70170_p);
                            this.tryExtinguish(player);
                        }
                    }
                }
            } else if (event.getSource() instanceof EntityDamageSource && ((EntityDamageSource)event.getSource()).func_180139_w() && event.getSource().func_76346_g() instanceof EntityGuardian && (stack = player.func_184614_ca()).func_77973_b() instanceof ItemMinigun && (minigun = ((ItemMinigun)stack.func_77973_b()).getMinigun(stack, player)) != null && minigun.getMinigunSpeed() >= 0.4) {
                event.setCanceled(true);
            }
        }
    }

    private void tryExtinguish(EntityPlayer player) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos pos = player.func_180425_c().func_177982_a(i, 0, j);
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150480_ab && player.func_70681_au().nextInt(3) == 0) {
                    player.field_70170_p.func_175698_g(pos);
                    continue;
                }
                if (state.func_177230_c() != Blocks.field_150353_l && state.func_177230_c() != Blocks.field_150356_k || player.func_70681_au().nextInt(5) != 0) continue;
                for (IProperty prop : state.func_177227_a()) {
                    if (!prop.func_177701_a().equals("level")) continue;
                    PropertyInteger iProp = (PropertyInteger)prop;
                    int level = (Integer)state.func_177229_b((IProperty)iProp);
                    player.field_70170_p.func_175656_a(pos, level == 0 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150347_e.func_176223_P());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.LEGS);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (!handler.isJetBootsEnabled() && handler.isArmorReady(EntityEquipmentSlot.LEGS) && handler.isJumpBoostEnabled() && handler.getArmorPressure(EntityEquipmentSlot.LEGS) > 0.01f) {
                float scale;
                float power = (float)ItemPneumaticArmor.getIntData(stack, "jumpBoost", 100) / 100.0f;
                int rangeUpgrades = handler.getUpgradeCount(EntityEquipmentSlot.LEGS, IItemRegistry.EnumUpgrade.RANGE, player.func_70093_af() ? 1 : 6);
                float actualBoost = Math.max(1.0f, (float)rangeUpgrades * power);
                player.field_70181_x += (double)(actualBoost * 0.15f);
                float rotRad = player.field_70177_z * ((float)Math.PI / 180);
                float f = scale = player.func_70051_ag() ? 0.25f * actualBoost : 0.15f * actualBoost;
                if (player.field_70159_w != 0.0) {
                    player.field_70159_w -= (double)(MathHelper.func_76126_a((float)rotRad) * scale);
                }
                if (player.field_70179_y != 0.0) {
                    player.field_70179_y += (double)(MathHelper.func_76134_b((float)rotRad) * scale);
                }
                armorJumping.put(player.func_110124_au(), player.field_70170_p.func_82737_E());
                int airUsed = (int)Math.ceil(20.0f * actualBoost * (float)(player.func_70051_ag() ? 2 : 1));
                handler.addAir(EntityEquipmentSlot.LEGS, -airUsed);
            }
        }
    }

    @SubscribeEvent
    public void breakSpeedCheck(PlayerEvent.BreakSpeed event) {
        int n;
        CommonArmorHandler handler;
        EntityPlayer player = event.getEntityPlayer();
        int max = 10;
        if (ItemPneumaticArmor.isPneumaticArmorPiece(player, EntityEquipmentSlot.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(event.getEntityPlayer())).isJetBootsEnabled() && !player.field_70122_E && handler.isJetBootsBuilderMode() && (n = max + 1 - handler.getUpgradeCount(EntityEquipmentSlot.FEET, IItemRegistry.EnumUpgrade.JET_BOOTS, max)) < 4) {
            float newSpeed;
            float mult = 5.0f / (float)n;
            float oldSpeed = event.getOriginalSpeed();
            if (oldSpeed < (newSpeed = event.getNewSpeed()) * mult) {
                event.setNewSpeed(newSpeed * mult);
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        CommonArmorHandler handler;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && ItemPneumaticArmor.isPneumaticArmorPiece(player = (EntityPlayer)event.getEntity(), EntityEquipmentSlot.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(player)).getArmorPressure(EntityEquipmentSlot.FEET) > 0.0f && handler.isArmorReady(EntityEquipmentSlot.FEET)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playJetbootsParticles(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.field_70170_p.field_72995_K) {
            JetBootsStateTracker tracker = JetBootsStateTracker.getTracker(event.player);
            for (EntityPlayer player : event.player.field_70170_p.field_73010_i) {
                JetBootsStateTracker.JetBootsState state;
                if (player.field_70122_E || !ItemPneumaticArmor.isPneumaticArmorPiece(player, EntityEquipmentSlot.FEET) || (state = tracker.getJetBootsState(player)) == null || !state.isEnabled()) continue;
                int nParticles = state.isActive() ? 5 : 1;
                Vec3d jetVec = state.shouldRotatePlayer() ? player.func_70040_Z().func_186678_a(-0.5) : IDLE_VEC;
                Vec3d feet = this.getFeetPos(player, state.shouldRotatePlayer());
                for (int i = 0; i < nParticles; ++i) {
                    PneumaticCraftRepressurized.proxy.playCustomParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, player.field_70170_p, feet.field_72450_a, feet.field_72448_b, feet.field_72449_c, jetVec.field_72450_a, jetVec.field_72448_b, jetVec.field_72449_c);
                }
            }
        }
    }

    private Vec3d getFeetPos(EntityPlayer player, boolean rotated) {
        if (!rotated) {
            return new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        double midY = (player.field_70163_u + player.func_174824_e((float)1.0f).field_72448_b) / 2.0;
        return new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v).func_178787_e(player.func_70040_Z().func_186678_a(player.field_70163_u - midY));
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            JetBootsStateTracker.JetBootsState state;
            EntityPlayerMP newPlayer = (EntityPlayerMP)event.getEntity();
            JetBootsStateTracker tracker = JetBootsStateTracker.getTracker((EntityPlayer)newPlayer);
            for (EntityPlayer player : event.getWorld().field_73010_i) {
                JetBootsStateTracker.JetBootsState state2;
                if (player.func_145782_y() == newPlayer.func_145782_y() || !ItemPneumaticArmor.isPneumaticArmorPiece((EntityPlayer)newPlayer, EntityEquipmentSlot.FEET) || (state2 = tracker.getJetBootsState(player)) == null) continue;
                NetworkHandler.sendTo(new PacketJetBootsStateSync(player, state2), newPlayer);
            }
            if (ItemPneumaticArmor.isPneumaticArmorPiece((EntityPlayer)newPlayer, EntityEquipmentSlot.FEET) && (state = tracker.getJetBootsState((EntityPlayer)newPlayer)) != null) {
                NetworkHandler.sendToDimension(new PacketJetBootsStateSync((EntityPlayer)newPlayer, state), event.getWorld().field_73011_w.getDimension());
            }
        }
    }
}

