/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public enum PlasticMixerRegistry {
    INSTANCE;

    private final Set<String> validFluids = new HashSet<String>();
    private final Map<Item, Boolean> validItems = new HashMap<Item, Boolean>();
    private final List<PlasticMixerRecipe> recipes = new ArrayList<PlasticMixerRecipe>();

    public void addPlasticMixerRecipe(@Nonnull FluidStack fluid, @Nonnull ItemStack stack, int temperature, boolean allowMelting, boolean allowSolidifying) {
        if (fluid.amount > 0 && !stack.func_190926_b()) {
            this.recipes.add(new PlasticMixerRecipe(fluid, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), temperature, allowMelting, allowSolidifying));
            this.validItems.put(stack.func_77973_b(), allowMelting);
            this.validFluids.add(fluid.getFluid().getName());
        } else {
            this.recipes.removeIf(record -> record.getFluidStack().getFluid() == fluid.getFluid());
            this.validItems.remove(stack.func_77973_b());
            this.validFluids.remove(fluid.getFluid().getName());
        }
    }

    public PlasticMixerRecipe getRecipe(FluidStack input) {
        if (input == null || input.amount == 0) {
            return null;
        }
        for (PlasticMixerRecipe recipe : this.recipes) {
            if (!recipe.allowSolidifying || recipe.fluidStack.getFluid() != input.getFluid() || ((PlasticMixerRecipe)recipe).fluidStack.amount > input.amount) continue;
            return recipe;
        }
        return null;
    }

    public PlasticMixerRecipe getRecipe(ItemStack stack) {
        for (PlasticMixerRecipe recipe : this.recipes) {
            if (!recipe.allowMelting || stack.func_77973_b() != recipe.itemStack.func_77973_b()) continue;
            return recipe;
        }
        return null;
    }

    public void clear() {
        this.recipes.clear();
        this.validFluids.clear();
        this.validItems.clear();
    }

    public Iterable<? extends PlasticMixerRecipe> allRecipes() {
        return this.recipes;
    }

    public boolean isValidInputItem(ItemStack stack) {
        return this.validItems.getOrDefault(stack.func_77973_b(), false);
    }

    public boolean isValidOutputItem(ItemStack stack) {
        return this.validItems.containsKey(stack.func_77973_b());
    }

    public boolean isValidFluid(FluidStack stack) {
        return this.validFluids.contains(stack.getFluid().getName());
    }

    public static class PlasticMixerRecipe {
        private final FluidStack fluidStack;
        private final ItemStack itemStack;
        private final int temperature;
        private final boolean allowMelting;
        private final boolean allowSolidifying;

        PlasticMixerRecipe(FluidStack fluidStack, ItemStack itemStack, int temperature, boolean allowMelting, boolean allowSolidifying) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
            this.temperature = temperature;
            this.allowMelting = allowMelting;
            this.allowSolidifying = allowSolidifying;
        }

        public FluidStack getFluidStack() {
            return this.fluidStack;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public boolean allowMelting() {
            return this.allowMelting;
        }

        public boolean allowSolidifying() {
            return this.allowSolidifying;
        }

        public int getTemperature() {
            return this.temperature;
        }

        public int getNumSubTypes() {
            Item item = this.getItemStack().func_77973_b();
            if (item.func_77640_w() == null) {
                return 1;
            }
            NonNullList subs = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), subs);
            return Math.max(1, subs.size());
        }
    }
}

