/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particles;

import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particle.ParticleTextureStitcher;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleSnowFlake
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "particles/snowflake");
    private int whichTex;
    private int swirlTick;
    private float spread;
    boolean swirls;

    public ParticleSnowFlake(World world, double x, double y, double z, double vX, double vY, double vZ, double duration, double swirls) {
        super(world, x, y, z);
        this.field_70544_f = 1.0f;
        this.whichTex = this.field_187136_p.nextInt(8);
        this.field_187129_i = vX;
        this.field_187130_j = vY;
        this.field_187131_k = vZ;
        this.field_70547_e = (int)duration;
        this.swirlTick = this.field_187136_p.nextInt(120);
        this.spread = this.field_187136_p.nextFloat();
        this.swirls = swirls == 1.0;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.swirls) {
            Vec3d motionVec = new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k).func_72432_b();
            float yaw = (float)Math.atan2(motionVec.field_72450_a, motionVec.field_72449_c);
            float xzDistance = (float)motionVec.func_72433_c();
            float pitch = (float)Math.atan2(motionVec.field_72448_b, xzDistance);
            float swirlRadius = 4.0f * ((float)this.field_70546_d / (float)this.field_70547_e) * this.spread;
            Point3d point = new Point3d((double)swirlRadius * Math.cos((double)this.swirlTick * 0.2), (double)swirlRadius * Math.sin((double)this.swirlTick * 0.2), 0.0);
            Matrix4d boxRotateX = new Matrix4d();
            Matrix4d boxRotateY = new Matrix4d();
            boxRotateX.rotX((double)pitch);
            boxRotateY.rotY((double)yaw);
            boxRotateX.transform(point);
            boxRotateY.transform(point);
            this.field_187126_f += point.x;
            this.field_187127_g += point.y;
            this.field_187128_h += point.z;
        }
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
        ++this.field_70546_d;
        ++this.swirlTick;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float var = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_82339_as = (float)(1.0 - Math.exp(10.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.field_82339_as < 0.1) {
            this.field_82339_as = 0.1f;
        }
        float f = (float)this.field_94054_b / 16.0f;
        float f1 = f + 0.0624375f;
        float f2 = (float)this.field_94055_c / 16.0f;
        float f3 = f2 + 0.0624375f;
        float f4 = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            int row = this.whichTex / 4;
            int column = this.whichTex % 4;
            f = this.field_187119_C.func_94214_a((double)((float)row / 4.0f * 16.0f));
            f1 = this.field_187119_C.func_94214_a((double)((float)(row + 1) / 4.0f * 16.0f));
            f2 = this.field_187119_C.func_94207_b((double)((float)column / 4.0f * 16.0f));
            f3 = this.field_187119_C.func_94207_b((double)((float)(column + 1) / 4.0f * 16.0f));
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleSnowFlake.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleSnowFlake.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleSnowFlake.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }

    public boolean func_187111_c() {
        return true;
    }

    public static final class SnowFlakeFactory
    extends ParticleFactory<SnowFlakeFactory, ParticleSnowFlake> {
        public SnowFlakeFactory() {
            super(ParticleSnowFlake.class, ParticleTextureStitcher.create(ParticleSnowFlake.class, new ResourceLocation("mowziesmobs", "particles/snowflake")));
        }

        @Override
        public ParticleSnowFlake createParticle(ParticleFactory.ImmutableParticleArgs args) {
            if (args.data.length >= 5) {
                return new ParticleSnowFlake(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], (Double)args.data[3], (Double)args.data[4]);
            }
            if (args.data.length == 4) {
                return new ParticleSnowFlake(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], (Double)args.data[3], 0.0);
            }
            if (args.data.length == 3) {
                return new ParticleSnowFlake(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], 40.0, 0.0);
            }
            return new ParticleSnowFlake(args.world, args.x, args.y, args.z, 0.0, 0.0, 0.0, 40.0, 0.0);
        }
    }
}

