/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particles.util;

import com.bobmowzie.mowziesmobs.client.particles.util.MowzieParticleBase;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.math.Vec3d;

public abstract class ParticleComponent {
    public void init(MowzieParticleBase particle) {
    }

    public void preUpdate(MowzieParticleBase particle) {
    }

    public void postUpdate(MowzieParticleBase particle) {
    }

    public void preRender(MowzieParticleBase particle, float partialTicks) {
    }

    public void postRender(MowzieParticleBase particle, BufferBuilder buffer, float partialTicks, int lightmapJ, int lightmapK) {
    }

    public static Constant constant(float value) {
        return new Constant(value);
    }

    public class AlphaControl
    extends ParticleComponent {
        public AlphaControl(float v, float v1) {
        }
    }

    public static class FaceMotion
    extends ParticleComponent {
        @Override
        public void preRender(MowzieParticleBase particle, float partialTicks) {
            super.preRender(particle, partialTicks);
            double dx = particle.getPosX() - particle.getPrevPosX();
            double dy = particle.getPosY() - particle.getPrevPosY();
            double dz = particle.getPosZ() - particle.getPrevPosZ();
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (d != 0.0) {
                double a = dy / d;
                a = Math.max(-1.0, Math.min(1.0, a));
                float pitch = -((float)Math.asin(a));
                float yaw = -((float)(Math.atan2(dz, dx) + Math.PI));
                particle.roll = pitch;
                particle.yaw = yaw;
            }
        }
    }

    public static class Orbit
    extends ParticleComponent {
        private Vec3d[] location;
        private AnimData phase;
        private AnimData radius;
        private AnimData axisX;
        private AnimData axisY;
        private AnimData axisZ;
        private boolean faceCamera;

        public Orbit(Vec3d[] location, AnimData phase, AnimData radius, AnimData axisX, AnimData axisY, AnimData axisZ, boolean faceCamera) {
            this.location = location;
            this.phase = phase;
            this.radius = radius;
            this.axisX = axisX;
            this.axisY = axisY;
            this.axisZ = axisZ;
            this.faceCamera = faceCamera;
        }

        @Override
        public void init(MowzieParticleBase particle) {
            this.apply(particle, 0.0f);
        }

        @Override
        public void preUpdate(MowzieParticleBase particle) {
            float ageFrac = particle.getAge() / particle.getMaxAge();
            this.apply(particle, ageFrac);
        }

        private void apply(MowzieParticleBase particle, float t) {
            Vec3d axis;
            float p = this.phase.evaluate(t);
            float r = this.radius.evaluate(t);
            if (this.faceCamera) {
                axis = Particle.field_190016_K;
            } else {
                axis = new Vec3d((double)this.axisX.evaluate(t), (double)this.axisY.evaluate(t), (double)this.axisZ.evaluate(t));
                axis = axis.func_72432_b();
            }
            Matrix4d quat = new Matrix4d();
            quat.setIdentity();
            AxisAngle4d axisAngle = new AxisAngle4d(axis.field_72450_a, axis.field_72448_b, axis.field_72449_c, (double)(p * (float)Math.PI * 2.0f));
            quat.setRotation(axisAngle);
            Vec3d up = new Vec3d(0.0, 1.0, 0.0);
            Vec3d start = axis.func_72431_c(up).func_72432_b();
            if (axis == up) {
                start = new Vec3d(1.0, 0.0, 0.0);
            }
            Point3d newPos = new Point3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            quat.transform(newPos);
            newPos.scale((double)r);
            if (this.location.length > 0 && this.location[0] != null) {
                newPos.x += this.location[0].field_72450_a;
                newPos.y += this.location[0].field_72448_b;
                newPos.z += this.location[0].field_72449_c;
            }
            particle.func_187109_b(newPos.x, newPos.y, newPos.z);
        }
    }

    public static class Attractor
    extends ParticleComponent {
        private Vec3d[] location;
        private float strength;
        private float killDist;
        private EnumAttractorBehavior behavior;
        private Vec3d startLocation;

        public Attractor(Vec3d[] location, float strength, float killDist, EnumAttractorBehavior behavior) {
            this.location = location;
            this.strength = strength;
            this.killDist = killDist;
            this.behavior = behavior;
        }

        @Override
        public void init(MowzieParticleBase particle) {
            this.startLocation = new Vec3d(particle.getPosX(), particle.getPosY(), particle.getPosZ());
        }

        @Override
        public void preUpdate(MowzieParticleBase particle) {
            float ageFrac = particle.getAge() / particle.getMaxAge();
            if (this.location.length > 0) {
                Vec3d destinationVec = this.location[0];
                Vec3d currPos = new Vec3d(particle.getPosX(), particle.getPosY(), particle.getPosZ());
                Vec3d diff = destinationVec.func_178788_d(currPos);
                if (diff.func_72433_c() < (double)this.killDist) {
                    particle.func_187112_i();
                }
                if (this.behavior == EnumAttractorBehavior.EXPONENTIAL) {
                    Vec3d path = destinationVec.func_178788_d(this.startLocation).func_186678_a(Math.pow(ageFrac, this.strength)).func_178787_e(this.startLocation).func_178788_d(currPos);
                    particle.func_187110_a(path.field_72450_a, path.field_72448_b, path.field_72449_c);
                } else if (this.behavior == EnumAttractorBehavior.LINEAR) {
                    Vec3d path = destinationVec.func_178788_d(this.startLocation).func_186678_a((double)ageFrac).func_178787_e(this.startLocation).func_178788_d(currPos);
                    particle.func_187110_a(path.field_72450_a, path.field_72448_b, path.field_72449_c);
                } else {
                    double dist = Math.max(diff.func_72433_c(), 0.001);
                    diff = diff.func_72432_b().func_186678_a((double)this.strength / (dist * dist));
                    particle.setMotionX(Math.min(particle.getMotionX() + diff.field_72450_a, 5.0));
                    particle.setMotionY(Math.min(particle.getMotionY() + diff.field_72448_b, 5.0));
                    particle.setMotionZ(Math.min(particle.getMotionZ() + diff.field_72449_c, 5.0));
                }
            }
        }

        public static enum EnumAttractorBehavior {
            LINEAR,
            EXPONENTIAL,
            SIMULATED;

        }
    }

    public static class PinLocation
    extends ParticleComponent {
        private Vec3d[] location;

        public PinLocation(Vec3d[] location) {
            this.location = location;
        }

        @Override
        public void init(MowzieParticleBase particle) {
            if (this.location.length > 0) {
                particle.func_187109_b(this.location[0].field_72450_a, this.location[0].field_72448_b, this.location[0].field_72449_c);
            }
        }

        @Override
        public void preUpdate(MowzieParticleBase particle) {
            if (this.location.length > 0) {
                particle.func_187109_b(this.location[0].field_72450_a, this.location[0].field_72448_b, this.location[0].field_72449_c);
            }
        }
    }

    public static class PropertyControl
    extends ParticleComponent {
        private AnimData animData;
        private EnumParticleProperty property;
        private boolean additive;

        public PropertyControl(EnumParticleProperty property, AnimData animData, boolean additive) {
            this.property = property;
            this.animData = animData;
            this.additive = additive;
        }

        @Override
        public void init(MowzieParticleBase particle) {
            float value = this.animData.evaluate(0.0f);
            this.applyUpdate(particle, value);
            this.applyRender(particle, value);
        }

        @Override
        public void preRender(MowzieParticleBase particle, float partialTicks) {
            float ageFrac = (particle.getAge() + partialTicks) / particle.getMaxAge();
            float value = this.animData.evaluate(ageFrac);
            this.applyRender(particle, value);
        }

        @Override
        public void preUpdate(MowzieParticleBase particle) {
            float ageFrac = particle.getAge() / particle.getMaxAge();
            float value = this.animData.evaluate(ageFrac);
            this.applyUpdate(particle, value);
        }

        private void applyUpdate(MowzieParticleBase particle, float value) {
            if (this.property == EnumParticleProperty.POS_X) {
                if (this.additive) {
                    particle.setPosX(particle.getPosX() + (double)value);
                } else {
                    particle.setPosX(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Y) {
                if (this.additive) {
                    particle.setPosY(particle.getPosY() + (double)value);
                } else {
                    particle.setPosY(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Z) {
                if (this.additive) {
                    particle.setPosZ(particle.getPosZ() + (double)value);
                } else {
                    particle.setPosZ(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_X) {
                if (this.additive) {
                    particle.setMotionX(particle.getMotionX() + (double)value);
                } else {
                    particle.setMotionX(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Y) {
                if (this.additive) {
                    particle.setMotionY(particle.getMotionY() + (double)value);
                } else {
                    particle.setMotionY(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Z) {
                if (this.additive) {
                    particle.setMotionZ(particle.getMotionZ() + (double)value);
                } else {
                    particle.setMotionZ(value);
                }
            } else if (this.property == EnumParticleProperty.AIR_DRAG) {
                particle.airDrag = this.additive ? (particle.airDrag += value) : value;
            }
        }

        private void applyRender(MowzieParticleBase particle, float value) {
            if (this.property == EnumParticleProperty.RED) {
                particle.red = this.additive ? (particle.red += value) : value;
            } else if (this.property == EnumParticleProperty.GREEN) {
                particle.green = this.additive ? (particle.green += value) : value;
            } else if (this.property == EnumParticleProperty.BLUE) {
                particle.blue = this.additive ? (particle.blue += value) : value;
            } else if (this.property == EnumParticleProperty.ALPHA) {
                particle.alpha = this.additive ? (particle.alpha += value) : value;
            } else if (this.property == EnumParticleProperty.SCALE) {
                particle.scale = this.additive ? (particle.scale += value) : value;
            } else if (this.property == EnumParticleProperty.YAW) {
                particle.yaw = this.additive ? (particle.yaw += value) : value;
            } else if (this.property == EnumParticleProperty.PITCH) {
                particle.pitch = this.additive ? (particle.pitch += value) : value;
            } else if (this.property == EnumParticleProperty.ROLL) {
                particle.roll = this.additive ? (particle.roll += value) : value;
            } else if (this.property == EnumParticleProperty.PARTICLE_ANGLE) {
                if (this.additive) {
                    particle.setAngle(particle.getAngle() + value);
                } else {
                    particle.setAngle(value);
                }
            }
        }

        public static enum EnumParticleProperty {
            POS_X,
            POS_Y,
            POS_Z,
            MOTION_X,
            MOTION_Y,
            MOTION_Z,
            RED,
            GREEN,
            BLUE,
            ALPHA,
            SCALE,
            YAW,
            PITCH,
            ROLL,
            PARTICLE_ANGLE,
            AIR_DRAG;

        }
    }

    public static class Constant
    extends AnimData {
        float value;

        public Constant(float value) {
            this.value = value;
        }

        @Override
        public float evaluate(float t) {
            return this.value;
        }
    }

    public static class Oscillator
    extends AnimData {
        float value1;
        float value2;
        float frequency;
        float phaseShift;

        public Oscillator(float value1, float value2, float frequency, float phaseShift) {
            this.value1 = value1;
            this.value2 = value2;
            this.frequency = frequency;
            this.phaseShift = phaseShift;
        }

        @Override
        public float evaluate(float t) {
            float a = (this.value2 - this.value1) / 2.0f;
            return (float)((double)(this.value1 + a) + (double)a * Math.cos(t * this.frequency + this.phaseShift));
        }
    }

    public static class KeyTrack
    extends AnimData {
        float[] values;
        float[] times;

        public KeyTrack(float[] values, float[] times) {
            this.values = values;
            this.times = times;
            if (values.length != times.length) {
                System.out.println("Malformed key track. Must have same number of keys and values or key track will evaluate to 0.");
            }
        }

        @Override
        public float evaluate(float t) {
            if (this.values.length != this.times.length) {
                return 0.0f;
            }
            for (int i = 0; i < this.times.length; ++i) {
                float time = this.times[i];
                if (t == time) {
                    return this.values[i];
                }
                if (t < time) {
                    if (i == 0) {
                        return this.values[0];
                    }
                    float a = (t - this.times[i - 1]) / (time - this.times[i - 1]);
                    return this.values[i - 1] * (1.0f - a) + this.values[i] * a;
                }
                if (i != this.values.length - 1) continue;
                return this.values[i];
            }
            return 0.0f;
        }

        public static KeyTrack startAndEnd(float startValue, float endValue) {
            return new KeyTrack(new float[]{startValue, endValue}, new float[]{0.0f, 1.0f});
        }

        public static KeyTrack oscillate(float value1, float value2, int frequency) {
            if (frequency <= 1) {
                new KeyTrack(new float[]{value1, value2}, new float[]{0.0f, 1.0f});
            }
            float step = 1.0f / (float)frequency;
            float[] times = new float[frequency + 1];
            float[] values = new float[frequency + 1];
            for (int i = 0; i < frequency + 1; ++i) {
                float value = i % 2 == 0 ? value1 : value2;
                times[i] = step * (float)i;
                values[i] = value;
            }
            return new KeyTrack(values, times);
        }
    }

    public static abstract class AnimData {
        public float evaluate(float t) {
            return 0.0f;
        }
    }
}

