/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particles.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particles.util.MowzieParticleBase;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityPoisonBall
extends EntityMagicEffect
implements IProjectile {
    public static float GRAVITY = 0.05f;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;

    public EntityPoisonBall(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityPoisonBall(World worldIn, EntityLivingBase caster) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        if (!this.field_70170_p.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        this.field_70159_w = x * (double)velocity;
        this.field_70181_x = y * (double)velocity;
        this.field_70179_y = z * (double)velocity;
    }

    @Override
    public void func_70071_h_() {
        this.prevMotionX = this.field_70159_w;
        this.prevMotionY = this.field_70181_x;
        this.prevMotionZ = this.field_70179_y;
        super.func_70071_h_();
        this.field_70181_x -= (double)GRAVITY;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f;
        List<EntityLivingBase> entitiesHit = this.getEntityLivingBaseNearby(1.0);
        if (!entitiesHit.isEmpty()) {
            for (EntityLivingBase entity : entitiesHit) {
                if (entity == this.caster || entity.func_190530_aW() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || entity instanceof EntityNaga) continue;
                entity.func_70097_a(DamageSource.func_76354_b((Entity)this.caster, null), 3.0f * ConfigHandler.NAGA.combatData.attackMultiplier);
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 80, 1, false, true));
            }
        }
        if (this.field_70170_p.func_184143_b(this.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1))) {
            this.explode();
        }
        if (this.field_70170_p.field_72995_K) {
            float scale = 1.0f;
            int steps = 4;
            for (int step = 0; step < steps; ++step) {
                double life;
                double value;
                double zSpeed;
                double ySpeed;
                double xSpeed;
                int i;
                double x = this.field_70169_q + (double)step * (this.field_70165_t - this.field_70169_q) / (double)steps;
                double y = this.field_70167_r + (double)step * (this.field_70163_u - this.field_70167_r) / (double)steps + (double)(this.field_70131_O / 2.0f);
                double z = this.field_70166_s + (double)step * (this.field_70161_v - this.field_70166_s) / (double)steps;
                for (i = 0; i < 1; ++i) {
                    xSpeed = (double)scale * 0.02 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.02 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.02 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    value = this.field_70146_Z.nextFloat() * 0.1f;
                    life = this.field_70146_Z.nextFloat() * 10.0f + 15.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, x, y, z, xSpeed, ySpeed, zSpeed, scale, 0.25 + value, 0.75 + value, 0.25 + value, 0.99, life);
                }
                for (i = 0; i < 2; ++i) {
                    xSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    value = this.field_70146_Z.nextFloat() * 0.1f;
                    life = this.field_70146_Z.nextFloat() * 5.0f + 10.0f;
                    MowzieParticleBase.spawnParticle(this.field_70170_p, MMParticle.PIXEL, x + xSpeed - this.field_70159_w * 0.5, y + ySpeed - this.field_70181_x * 0.5, z + zSpeed - this.field_70179_y * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0f, scale * 3.0f, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.99, life * 0.9, false);
                }
                for (i = 0; i < 1; ++i) {
                    if (!(this.field_70146_Z.nextFloat() < 0.9f)) continue;
                    xSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    ySpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    zSpeed = (double)scale * 0.06 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f);
                    value = this.field_70146_Z.nextFloat() * 0.1f;
                    life = this.field_70146_Z.nextFloat() * 5.0f + 10.0f;
                    MowzieParticleBase.spawnParticle(this.field_70170_p, MMParticle.BUBBLE, x - this.field_70159_w * 0.5, y - this.field_70181_x * 0.5, z - this.field_70179_y * 0.5, xSpeed, ySpeed, zSpeed, true, 0.0, 0.0, 0.0, 0.0f, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.85, life, false);
                }
            }
        }
        if (this.field_70173_aa > 50) {
            this.func_70106_y();
        }
    }

    private void explode() {
        float explodeSpeed = 3.5f;
        if (this.field_70170_p.field_72995_K) {
            double life;
            double value;
            Vec3d particlePos;
            int i;
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3d(Math.random() * 0.25, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)(Math.random() * 2.0 * Math.PI));
                particlePos = particlePos.func_178789_a((float)(Math.random() * 2.0 * Math.PI));
                value = this.field_70146_Z.nextFloat() * 0.1f;
                life = this.field_70146_Z.nextFloat() * 17.0f + 30.0f;
                ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
            }
            for (i = 0; i < 26; ++i) {
                particlePos = new Vec3d(Math.random() * 0.25, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)(Math.random() * 2.0 * Math.PI));
                particlePos = particlePos.func_178789_a((float)(Math.random() * 2.0 * Math.PI));
                value = this.field_70146_Z.nextFloat() * 0.1f;
                life = this.field_70146_Z.nextFloat() * 5.0f + 10.0f;
                MowzieParticleBase.spawnParticle(this.field_70170_p, MMParticle.PIXEL, this.field_70165_t + particlePos.field_72450_a, this.field_70163_u + particlePos.field_72448_b, this.field_70161_v + particlePos.field_72449_c, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0f, 3.0, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.6, life * 0.95, false);
            }
            for (i = 0; i < 23; ++i) {
                particlePos = new Vec3d(Math.random() * 0.25, 0.0, 0.0);
                particlePos = particlePos.func_178785_b((float)(Math.random() * 2.0 * Math.PI));
                particlePos = particlePos.func_178789_a((float)(Math.random() * 2.0 * Math.PI));
                value = this.field_70146_Z.nextFloat() * 0.1f;
                life = this.field_70146_Z.nextFloat() * 10.0f + 20.0f;
                MowzieParticleBase.spawnParticle(this.field_70170_p, MMParticle.BUBBLE, this.field_70165_t + particlePos.field_72450_a, this.field_70163_u + particlePos.field_72448_b, this.field_70161_v + particlePos.field_72449_c, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0f, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.6, life * 0.95, false);
            }
        }
        this.func_184185_a(MMSounds.ENTITY_NAGA_ACID_HIT, 1.0f, 1.0f);
        List<EntityLivingBase> entitiesHit = this.getEntityLivingBaseNearby(2.0);
        if (!entitiesHit.isEmpty()) {
            for (EntityLivingBase entity : entitiesHit) {
                if (entity == this.caster || entity.func_190530_aW() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || entity instanceof EntityNaga) continue;
                entity.func_70097_a(DamageSource.func_76354_b((Entity)this.caster, null), 3.0f * ConfigHandler.NAGA.combatData.attackMultiplier);
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 80, 0, false, true));
            }
        }
        this.func_70106_y();
    }
}

