/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TransporterImpl
extends TransmitterImpl<TileEntity, InventoryNetwork, Void>
implements ILogisticalTransporter {
    private Map<Integer, TransporterStack> transit = new HashMap<Integer, TransporterStack>();
    private int nextId = 0;
    private EnumColor color;
    private Map<Integer, TransporterStack> needsSync = new HashMap<Integer, TransporterStack>();

    public TransporterImpl(TileEntityLogisticalTransporter multiPart) {
        super(multiPart);
    }

    public Collection<TransporterStack> getTransit() {
        return Collections.unmodifiableCollection(this.transit.values());
    }

    public void deleteStack(int id) {
        this.transit.remove(id);
    }

    public void addStack(int id, TransporterStack s) {
        this.transit.put(id, s);
    }

    public void writeToPacket(TileNetworkList data) {
        data.add(this.transit.size());
        for (Map.Entry<Integer, TransporterStack> entry : this.transit.entrySet()) {
            data.add(entry.getKey());
            entry.getValue().write(this, data);
        }
    }

    public void readFromPacket(ByteBuf dataStream) {
        this.transit.clear();
        int count = dataStream.readInt();
        for (int i = 0; i < count; ++i) {
            int id = dataStream.readInt();
            TransporterStack s = TransporterStack.readFromPacket(dataStream);
            this.transit.put(id, s);
        }
    }

    public void readFromNBT(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("color")) {
            this.setColor(TransporterUtils.colors.get(nbtTags.func_74762_e("color")));
        }
        if (nbtTags.func_74764_b("stacks")) {
            NBTTagList tagList = nbtTags.func_150295_c("stacks", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                TransporterStack stack = TransporterStack.readFromNBT(tagList.func_150305_b(i));
                this.transit.put(this.nextId++, stack);
            }
        }
    }

    public void update() {
        if (this.world().field_72995_K) {
            for (TransporterStack stack : this.transit.values()) {
                stack.progress = Math.min(100, stack.progress + this.getTileEntity().tier.getSpeed());
            }
        } else if (this.getTransmitterNetwork() != null) {
            HashSet<Integer> deletes = new HashSet<Integer>();
            this.getTileEntity().pullItems();
            Coord4D coord = this.coord();
            for (Map.Entry<Integer, TransporterStack> entry : this.transit.entrySet()) {
                int stackId = entry.getKey();
                TransporterStack stack = entry.getValue();
                if (!(stack.initiatedPath || !stack.itemStack.func_190926_b() && this.recalculate(stackId, stack, null))) {
                    deletes.add(stackId);
                    continue;
                }
                stack.progress += this.getTileEntity().tier.getSpeed();
                if (stack.progress >= 100) {
                    Coord4D prevSet = null;
                    if (stack.hasPath()) {
                        TileEntity tile;
                        int currentIndex = stack.getPath().indexOf(coord);
                        if (currentIndex == 0) {
                            deletes.add(stackId);
                            continue;
                        }
                        Coord4D next = stack.getPath().get(currentIndex - 1);
                        if (!stack.isFinal(this)) {
                            if (next != null && stack.canInsertToTransporter(next.getTileEntity((IBlockAccess)this.world()), stack.getSide(this))) {
                                ILogisticalTransporter nextTile = CapabilityUtils.getCapability((ICapabilityProvider)next.getTileEntity((IBlockAccess)this.world()), Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
                                nextTile.entityEntering(stack, stack.progress % 100);
                                deletes.add(stackId);
                                continue;
                            }
                            if (next != null) {
                                prevSet = next;
                            }
                        } else if (stack.getPathType() != TransporterStack.Path.NONE && (tile = next.getTileEntity((IBlockAccess)this.world())) != null) {
                            TransitRequest.TransitResponse response = InventoryUtils.putStackInInventory(tile, TransitRequest.getFromTransport(stack), stack.getSide(this), stack.getPathType() == TransporterStack.Path.HOME);
                            if (response.getRejected(stack.itemStack).func_190926_b()) {
                                TransporterManager.remove(stack);
                                deletes.add(stackId);
                                continue;
                            }
                            stack.itemStack = response.getRejected(stack.itemStack);
                            prevSet = next;
                        }
                    }
                    if (!this.recalculate(stackId, stack, prevSet)) {
                        deletes.add(stackId);
                        continue;
                    }
                    if (prevSet != null) {
                        stack.progress = 0;
                        continue;
                    }
                    stack.progress = 50;
                    continue;
                }
                if (stack.progress != 50) continue;
                if (stack.isFinal(this)) {
                    if (!this.checkPath(stack, TransporterStack.Path.DEST, false) && !this.checkPath(stack, TransporterStack.Path.HOME, true) && stack.getPathType() != TransporterStack.Path.NONE || this.recalculate(stackId, stack, null)) continue;
                    deletes.add(stackId);
                    continue;
                }
                TileEntity next = stack.getNext(this).getTileEntity((IBlockAccess)this.world());
                if (stack.canInsertToTransporter(next, stack.getSide(this)) || this.recalculate(stackId, stack, null)) continue;
                deletes.add(stackId);
            }
            if (deletes.size() > 0 || this.needsSync.size() > 0) {
                PacketTileEntity.TileEntityMessage msg = new PacketTileEntity.TileEntityMessage(coord, this.getTileEntity().makeBatchPacket(this.needsSync, deletes));
                deletes.forEach(id -> this.transit.remove(id));
                this.needsSync.clear();
                Mekanism.packetHandler.sendToAllTracking((IMessage)msg, coord);
                MekanismUtils.saveChunk(this.getTileEntity());
            }
        }
    }

    private boolean checkPath(TransporterStack stack, TransporterStack.Path dest, boolean home) {
        return stack.getPathType() == dest && (!this.checkSideForInsert(stack) || !InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.world()), stack.color, stack.itemStack, stack.getSide(this), home));
    }

    private boolean checkSideForInsert(TransporterStack stack) {
        EnumFacing side = stack.getSide(this);
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PUSH;
    }

    private boolean recalculate(int stackId, TransporterStack stack, Coord4D from) {
        if (stack.getPathType() != TransporterStack.Path.NONE) {
            TransitRequest.TransitResponse ret = stack.recalculatePath(TransitRequest.getFromTransport(stack), this, 0);
            if (ret.isEmpty() && !stack.calculateIdle(this)) {
                TransporterUtils.drop(this, stack);
                return false;
            }
        } else if (!stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        this.needsSync.put(stackId, stack);
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    @Override
    public TransitRequest.TransitResponse insert(Coord4D original, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        EnumFacing from = this.coord().sideDifference(original).func_176734_d();
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = original;
        stack.homeLocation = original;
        stack.color = color;
        if (!stack.canInsertToTransporter(this, from)) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        TransitRequest.TransitResponse response = stack.recalculatePath(request, this, min);
        return this.getTransitResponse(doEmit, stack, response);
    }

    @Nonnull
    private TransitRequest.TransitResponse getTransitResponse(boolean doEmit, TransporterStack stack, TransitRequest.TransitResponse response) {
        if (!response.isEmpty()) {
            stack.itemStack = response.getStack();
            if (doEmit) {
                int stackId = this.nextId++;
                this.transit.put(stackId, stack);
                Coord4D coord = this.coord();
                Mekanism.packetHandler.sendToAllTracking((IMessage)new PacketTileEntity.TileEntityMessage(coord, this.getTileEntity().makeSyncPacket(stackId, stack)), coord);
                MekanismUtils.saveChunk(this.getTileEntity());
            }
            return response;
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    @Override
    public TransitRequest.TransitResponse insertRR(TileEntityLogisticalSorter outputter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        EnumFacing from = this.coord().sideDifference(Coord4D.get(outputter)).func_176734_d();
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = Coord4D.get(outputter);
        stack.homeLocation = Coord4D.get(outputter);
        stack.color = color;
        if (!this.canReceiveFrom(outputter, from) || !stack.canInsertToTransporter(this, from)) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        TransitRequest.TransitResponse response = stack.recalculateRRPath(request, outputter, this, min);
        return this.getTransitResponse(doEmit, stack, response);
    }

    @Override
    public void entityEntering(TransporterStack stack, int progress) {
        int stackId = this.nextId++;
        stack.progress = progress;
        this.transit.put(stackId, stack);
        this.needsSync.put(stackId, stack);
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor c) {
        this.color = c;
    }

    @Override
    public boolean canEmitTo(TileEntity tileEntity, EnumFacing side) {
        if (!this.getTileEntity().canConnect(side)) {
            return false;
        }
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PUSH;
    }

    @Override
    public boolean canReceiveFrom(TileEntity tileEntity, EnumFacing side) {
        if (!this.getTileEntity().canConnect(side)) {
            return false;
        }
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public double getCost() {
        return this.getTileEntity().getCost();
    }

    @Override
    public boolean canConnectMutual(EnumFacing side) {
        return this.getTileEntity().canConnectMutual(side);
    }

    @Override
    public boolean canConnect(EnumFacing side) {
        return this.getTileEntity().canConnect(side);
    }

    public TileEntityLogisticalTransporter getTileEntity() {
        return (TileEntityLogisticalTransporter)this.containingTile;
    }
}

