/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine;

import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.machine.low.TileEntityCanner;
import ic2.core.block.machine.low.TileEntityCompressor;
import ic2.core.block.machine.low.TileEntityCropAnalyzer;
import ic2.core.block.machine.low.TileEntityCropmatron;
import ic2.core.block.machine.low.TileEntityElectricFurnace;
import ic2.core.block.machine.low.TileEntityElectrolyzer;
import ic2.core.block.machine.low.TileEntityExtractor;
import ic2.core.block.machine.low.TileEntityIronFurnace;
import ic2.core.block.machine.low.TileEntityMacerator;
import ic2.core.block.machine.low.TileEntityMagnetizer;
import ic2.core.block.machine.low.TileEntityMiner;
import ic2.core.block.machine.low.TileEntityPump;
import ic2.core.block.machine.low.TileEntityRecycler;
import ic2.core.block.machine.low.TileEntitySoundBeacon;
import ic2.core.block.machine.low.TileEntityStoneMacerator;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.IMetaSoundBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLVMachine
extends BlockMultiID
implements IBootable,
IMetaSoundBlock {
    public BlockLVMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setUnlocalizedName(Ic2BlockLang.machinesLV);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void onLoad() {
        Ic2States.machine = this.func_176203_a(0);
        Ic2States.ironFurnace = this.func_176203_a(1);
        Ic2States.electroFurnace = this.func_176203_a(2);
        Ic2States.macerator = this.func_176203_a(3);
        Ic2States.extractor = this.func_176203_a(4);
        Ic2States.compressor = this.func_176203_a(5);
        Ic2States.canner = this.func_176203_a(6);
        Ic2States.recycler = this.func_176203_a(7);
        Ic2States.electrolyzer = this.func_176203_a(8);
        Ic2States.cropAnaylzer = this.func_176203_a(9);
        Ic2States.magnetizer = this.func_176203_a(10);
        Ic2States.pump = this.func_176203_a(11);
        Ic2States.miner = this.func_176203_a(12);
        Ic2States.cropmatron = this.func_176203_a(13);
        Ic2States.soundBeacon = this.func_176203_a(14);
        Ic2States.stoneMacerator = this.func_176203_a(15);
        Ic2Items.machine = new ItemStack((Block)this, 1, 0);
        Ic2Items.ironFurnace = new ItemStack((Block)this, 1, 1);
        Ic2Items.electroFurnace = new ItemStack((Block)this, 1, 2);
        Ic2Items.macerator = new ItemStack((Block)this, 1, 3);
        Ic2Items.extractor = new ItemStack((Block)this, 1, 4);
        Ic2Items.compressor = new ItemStack((Block)this, 1, 5);
        Ic2Items.canner = new ItemStack((Block)this, 1, 6);
        Ic2Items.recycler = new ItemStack((Block)this, 1, 7);
        Ic2Items.electrolyzer = new ItemStack((Block)this, 1, 8);
        Ic2Items.cropAnalyzerBlock = new ItemStack((Block)this, 1, 9);
        Ic2Items.magnetizer = new ItemStack((Block)this, 1, 10);
        Ic2Items.pump = new ItemStack((Block)this, 1, 11);
        Ic2Items.miner = new ItemStack((Block)this, 1, 12);
        Ic2Items.cropmatron = new ItemStack((Block)this, 1, 13);
        Ic2Items.soundBeacon = new ItemStack((Block)this, 1, 14);
        Ic2Items.stoneMacerator = new ItemStack((Block)this, 1, 15);
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        if (meta >= 2 && meta <= 7) {
            return true;
        }
        return meta == 10;
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (Integer meta : this.getValidMetas()) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)meta).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)meta).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
            }
        }
        return states;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        switch (meta) {
            case 1: {
                return new TileEntityIronFurnace();
            }
            case 2: {
                return new TileEntityElectricFurnace();
            }
            case 3: {
                return new TileEntityMacerator();
            }
            case 4: {
                return new TileEntityExtractor();
            }
            case 5: {
                return new TileEntityCompressor();
            }
            case 6: {
                return new TileEntityCanner();
            }
            case 7: {
                return new TileEntityRecycler();
            }
            case 8: {
                return new TileEntityElectrolyzer();
            }
            case 9: {
                return new TileEntityCropAnalyzer();
            }
            case 10: {
                return new TileEntityMagnetizer();
            }
            case 11: {
                return new TileEntityPump();
            }
            case 12: {
                return new TileEntityMiner();
            }
            case 13: {
                return new TileEntityCropmatron();
            }
            case 14: {
                return new TileEntitySoundBeacon();
            }
            case 15: {
                return new TileEntityStoneMacerator();
            }
        }
        return new TileEntityBlock();
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        switch (meta) {
            case 1: {
                return meta;
            }
            case 2: {
                return meta;
            }
            case 15: {
                return meta;
            }
        }
        return 0;
    }

    @Override
    public List<Integer> getValidMetas() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        return Ic2Icons.getTextures("bmach_lv");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)(state = this.func_176221_a(state, (IBlockAccess)world, pos)).func_177229_b((IProperty)active)).booleanValue()) {
            int meta = this.func_176201_c(state);
            if (meta == 1) {
                TileEntity te = world.func_175625_s(pos);
                int facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing().func_176745_a() : 0;
                float f = (float)pos.func_177958_n() + 0.5f;
                float f2 = (float)pos.func_177956_o() + 0.0f + world.field_73012_v.nextFloat() * 6.0f / 16.0f;
                float f3 = (float)pos.func_177952_p() + 0.5f;
                float f4 = 0.52f;
                float f5 = world.field_73012_v.nextFloat() * 0.6f - 0.3f;
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                boolean spawn = false;
                if (facing == 2) {
                    x = f + f5;
                    y = f2;
                    z = f3 - f4;
                    spawn = true;
                } else if (facing == 3) {
                    x = f + f5;
                    y = f2;
                    z = f3 + f4;
                    spawn = true;
                } else if (facing == 4) {
                    x = f - f4;
                    y = f2;
                    z = f3 + f5;
                    spawn = true;
                } else if (facing == 5) {
                    x = f + f4;
                    y = f2;
                    z = f3 + f5;
                    spawn = true;
                }
                if (spawn) {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (meta == 3 || meta == 15) {
                float f6 = (float)pos.func_177958_n() + 1.0f;
                float f7 = (float)pos.func_177956_o() + 1.0f;
                float f8 = (float)pos.func_177952_p() + 1.0f;
                for (int z = 0; z < 4; ++z) {
                    float fmod = -0.2f - rand.nextFloat() * 0.6f;
                    float f1mod = -0.1f + rand.nextFloat() * 0.2f;
                    float f2mod = -0.2f - rand.nextFloat() * 0.6f;
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f6 + fmod), (double)(f7 + f1mod), (double)(f8 + f2mod), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public SoundType getSoundFromState(IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)this.getMetadataProperty()) == 15) {
            return SoundType.field_185851_d;
        }
        return null;
    }
}

