/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.core.IC2;
import ic2.core.block.wiring.tile.TileEntityCable;
import ic2.core.block.wiring.tile.TileEntityMultipartLuminator;
import ic2.core.item.block.ItemBlockRare;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockMultipartLuminator
extends ItemBlockRare {
    public ItemBlockMultipartLuminator(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
        if (handler.hasEUReader()) {
            tooltip.add(Ic2InfoLang.euReaderSinkInfo.getLocalizedFormatted(32));
        }
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityMultipartLuminator) {
            TileEntityMultipartLuminator multi = (TileEntityMultipartLuminator)tile;
            if (multi.hasSide(facing.func_176745_a())) {
                return EnumActionResult.FAIL;
            }
            multi.addLamp(facing.func_176745_a());
            if (IC2.platform.isRendering()) {
                SoundType soundtype = SoundType.field_185853_f;
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        if (tile instanceof TileEntityCable) {
            TileEntity newTile;
            TileEntityCable cable = (TileEntityCable)tile;
            if (cable.cableType == 5 || cable.cableType == 6) {
                return EnumActionResult.FAIL;
            }
            ItemStack cableStack = new ItemStack(Ic2Items.copperCable.func_77973_b(), 1, cable.getAsItemMeta());
            if (worldIn.func_175656_a(pos, Ic2States.luminatorMultipart) && (newTile = worldIn.func_175625_s(pos)) instanceof TileEntityMultipartLuminator) {
                TileEntityMultipartLuminator multi = (TileEntityMultipartLuminator)newTile;
                multi.setCable(cableStack, cable.cableColor, facing.func_176745_a());
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (IC2.platform.isRendering()) {
                    SoundType soundtype = SoundType.field_185853_f;
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }
}

