/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.inventory;

import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.item.upgrades.subtypes.inventory.BaseMetaInventoryUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AccessUpgrade
extends BaseMetaInventoryUpgrade {
    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean adv, Map<ToolTipType, List<String>> sortedToolTips) {
        super.addInformation(stack, player, list, adv, sortedToolTips);
        List<String> ctrlList = sortedToolTips.get((Object)ToolTipType.Ctrl);
        ctrlList.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlList.add(TextFormatting.UNDERLINE + Ic2InfoLang.invUpgradeModifySide.getLocalized());
        ctrlList.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(9), Ic2InfoLang.invUpgradeLoadData));
        List<String> altList = sortedToolTips.get((Object)ToolTipType.Alt);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (!nbt.func_74767_n("Loaded")) {
            list.add(Ic2InfoLang.invUpgradeNeedsBound.getLocalized());
            return;
        }
        byte[] array = nbt.func_74770_j("Current");
        AccessRule[] rule = AccessRule.values();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            altList.add(Ic2InfoLang.invUpgradeSideInfo.getLocalizedFormatted(Ic2Lang.getFacingComp(side).getLocalized(), rule[array[side.func_176745_a()]].getName()));
        }
    }

    @Override
    public void onInstalling(ItemStack stack, IHasHandler.IInventoryHandler handler) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (!nbt.func_74767_n("Loaded")) {
            return;
        }
        if (!nbt.func_74779_i("ID").equals(handler.getInventoryID())) {
            return;
        }
        AccessRule[] rules = AccessRule.values();
        byte[] setup = nbt.func_74770_j("Current");
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            handler.modifySideAccess(RotationList.ofFacings(facing), rules[setup[facing.func_176745_a()]]);
        }
    }

    @Override
    public IInventoryModifier.EffectType getEffect() {
        return IInventoryModifier.EffectType.Block;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return Ic2Icons.getTextures("i1")[161];
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.accessUpgrade;
    }

    @Override
    public boolean hasBlockClick() {
        return true;
    }

    @Override
    public EnumActionResult onBlockClick(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (!player.func_70093_af()) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            if (!nbt.func_74767_n("Loaded")) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Ic2InfoLang.invUpgradeNeedsBound);
                return EnumActionResult.FAIL;
            }
            byte[] setup = nbt.func_74770_j("Defaults");
            byte[] current = nbt.func_74770_j("Current");
            AccessRule next = AccessRule.values()[current[side.func_176745_a()]].createNextRule(AccessRule.values()[setup[side.func_176745_a()]]);
            current[side.func_176745_a()] = (byte)next.ordinal();
            nbt.func_74773_a("Current", current);
            IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeSideSet, side, next.getName());
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHasHandler) {
            IHasHandler handler = (IHasHandler)tile;
            InventoryHandler inv = handler.getHandler();
            if (inv == null || !inv.canModifySlots()) {
                IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeBoundFailed);
                return EnumActionResult.FAIL;
            }
            this.readFromBlock(stack, inv);
            IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeBoundSuccess);
            return EnumActionResult.SUCCESS;
        }
        return super.onBlockClick(stack, world, pos, side, player, hand);
    }

    private void readFromBlock(ItemStack stack, InventoryHandler handler) {
        byte[] setup = new byte[6];
        byte[] current = new byte[6];
        for (EnumFacing side : EnumFacing.field_82609_l) {
            byte by = (byte)handler.getDefaultAccess(side).ordinal();
            setup[side.func_176745_a()] = by;
            current[side.func_176745_a()] = by;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        nbt.func_74757_a("Loaded", true);
        nbt.func_74773_a("Defaults", setup);
        nbt.func_74773_a("Current", current);
        nbt.func_74778_a("ID", handler.getInventoryID());
    }
}

