/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.worldengine;

import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_Biome;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProvider;
import asmodeuscore.core.astronomy.dimension.world.worldengine.additions.WE_CreateChunkGen;
import asmodeuscore.core.astronomy.dimension.world.worldengine.additions.WE_CreateChunkGen_InXYZ;
import asmodeuscore.core.astronomy.dimension.world.worldengine.additions.WE_CreateChunkGen_InXZ;
import asmodeuscore.core.astronomy.dimension.world.worldengine.additions.WE_GeneratorData;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_CaveGen;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_LakeGen;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_OreGen;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_RavineGen;
import asmodeuscore.core.astronomy.dimension.world.worldengine.standardcustomgen.WE_TerrainGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WE_ChunkProvider
implements IChunkProvider,
IChunkGenerator {
    public World worldObj;
    public Random rand;
    private final Gradient noiseGen5;
    public List<WE_CreateChunkGen> createChunkGen_List = new ArrayList<WE_CreateChunkGen>();
    public List<WE_CreateChunkGen_InXZ> createChunkGen_InXZ_List = new ArrayList<WE_CreateChunkGen_InXZ>();
    public List<WE_CreateChunkGen_InXYZ> createChunkGen_InXYZ_List = new ArrayList<WE_CreateChunkGen_InXYZ>();
    public List<IWorldGenerator> decorateChunkGen_List = new ArrayList<IWorldGenerator>();
    public List<MapGenBaseMeta> worldGenerators = new ArrayList<MapGenBaseMeta>();
    private BiomeDecoratorSpace decorator;
    public List<WE_Biome> biomesList = new ArrayList<WE_Biome>();
    public WE_Biome standardBiomeOnMap;
    public double biomemapPersistence = 1.0;
    public double biomemapScaleX = 1.0;
    public double biomemapScaleY = 1.0;
    public int biomemapNumberOfOctaves = 1;
    public int random;
    public int CRATER_PROB = 0;
    private final WE_WorldProvider wp;

    public WE_ChunkProvider(WE_WorldProvider wp) {
        this.rand = new Random(wp.getSeed());
        this.worldObj = wp.field_76579_a;
        this.noiseGen5 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.wp = wp;
        this.createChunkGen_List.add(new WE_TerrainGenerator());
        this.createChunkGen_List.add(new WE_CaveGen());
        this.createChunkGen_List.add(new WE_RavineGen());
        WE_OreGen standardOres = new WE_OreGen();
        standardOres.add(Blocks.field_150352_o, (byte)0, Blocks.field_150348_b, (byte)0, 4, 0, 32, 4, 24, 45, 16);
        standardOres.add(Blocks.field_150366_p, (byte)0, Blocks.field_150348_b, (byte)0, 6, 0, 64, 8, 32, 90, 72);
        standardOres.add(Blocks.field_150365_q, (byte)0, Blocks.field_150348_b, (byte)0, 6, 32, 128, 16, 48, 60, 56);
        standardOres.add(Blocks.field_150369_x, (byte)0, Blocks.field_150348_b, (byte)0, 4, 0, 16, 8, 24, 30, 16);
        standardOres.add(Blocks.field_150482_ag, (byte)0, Blocks.field_150348_b, (byte)0, 3, 0, 16, 4, 24, 45, 16);
        standardOres.add(Blocks.field_150412_bA, (byte)0, Blocks.field_150348_b, (byte)0, 2, 0, 16, 4, 24, 45, 24);
        this.decorateChunkGen_List.add(standardOres);
        WE_LakeGen lavaLakes = new WE_LakeGen();
        lavaLakes.lakeBlock = Blocks.field_150353_l.func_176223_P();
        lavaLakes.fGen = false;
        lavaLakes.maxY = 32;
        this.decorateChunkGen_List.add(lavaLakes);
        wp.genSettings(this);
        this.decorator = wp.getDecorator();
        WE_Biome.setChunkProvider(this);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer primer = new ChunkPrimer();
        this.rand.setSeed((long)chunkX * 6824L * this.rand.nextLong() + (long)chunkZ * 146346L * this.rand.nextLong() + 315723968L);
        try {
            int z;
            int x;
            this.noiseGen5.setFrequency(0.01f);
            long chunk_X = (long)chunkX * 16L;
            long chunk_Z = (long)chunkZ * 16L;
            WE_Biome.setChunkProvider(this);
            this.random = this.worldObj.field_73012_v.nextInt(100);
            WE_Biome[][] chunkBiomes = new WE_Biome[16][16];
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    chunkBiomes[x][z] = WE_Biome.getBiomeAt(this, chunk_X + (long)x, chunk_Z + (long)z);
                }
            }
            for (int i = 0; i < this.createChunkGen_List.size(); ++i) {
                this.createChunkGen_List.get(i).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, 0, 0, 0));
            }
            if (this.CRATER_PROB > 0) {
                this.createCraters(chunkX, chunkZ, primer);
            }
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    int i;
                    for (i = 0; i < this.createChunkGen_InXZ_List.size(); ++i) {
                        this.createChunkGen_InXZ_List.get(i).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                    }
                    for (i = 0; i < chunkBiomes[x][z].createChunkGen_InXZ_List.size(); ++i) {
                        chunkBiomes[x][z].createChunkGen_InXZ_List.get(i).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                    }
                    for (int y = 255; y >= 0; --y) {
                        int i2;
                        for (i2 = 0; i2 < this.createChunkGen_InXYZ_List.size(); ++i2) {
                            this.createChunkGen_InXYZ_List.get(i2).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                        }
                        for (i2 = 0; i2 < chunkBiomes[x][z].createChunkGen_InXYZ_List.size(); ++i2) {
                            chunkBiomes[x][z].createChunkGen_InXYZ_List.get(i2).gen(new WE_GeneratorData(this, primer, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                        }
                    }
                }
            }
            this.wp.onChunkProvider(chunkX, chunkZ, primer);
            for (MapGenBaseMeta generator : this.worldGenerators) {
                generator.generate(this.worldObj, chunkX, chunkZ, primer);
            }
        }
        catch (Exception e) {
            FMLLog.warning((String)("Error caught in planetary worldgen at coords " + chunkX + "," + chunkZ + "."), (Object[])new Object[0]);
            e.printStackTrace();
        }
        Chunk chunk = new Chunk(this.worldObj, primer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        boolean flag = false;
        this.rand.setSeed((long)chunkX * 434673L * this.rand.nextLong() + (long)chunkZ * 585694L * this.rand.nextLong() + 745849494845L);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.worldObj, this.rand, chunkX, chunkZ, flag));
        for (int i = 0; i < this.decorateChunkGen_List.size(); ++i) {
            this.decorateChunkGen_List.get(i).generate(this.rand, x, z, this.worldObj, (IChunkGenerator)this, (IChunkProvider)this);
        }
        WE_Biome b = WE_Biome.getBiomeAt(this, x, z);
        for (int i = 0; i < b.decorateChunkGen_List.size(); ++i) {
            b.decorateChunkGen_List.get(i).generate(this.rand, x, z, this.worldObj, (IChunkGenerator)this, (IChunkProvider)this);
        }
        this.decorateWorld(this.worldObj, this.rand, x, z);
        this.wp.onPopulate(chunkX, chunkZ);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.worldObj, this.rand, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public void decorateWorld(World world, Random rand, int x, int z) {
        this.getBiomeGenerator().decorate(world, rand, x, z);
    }

    protected BiomeDecoratorSpace getBiomeGenerator() {
        return this.decorator;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        WE_Biome biome = WE_Biome.getBiomeAt(this, pos.func_177958_n(), pos.func_177952_p());
        if (biome != null) {
            return biome.func_76747_a(creatureType);
        }
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        this.wp.recreateStructures(chunkIn, x, z);
    }

    public Chunk func_186026_b(int x, int z) {
        return null;
    }

    public Chunk func_186025_d(int x, int z) {
        return null;
    }

    public boolean func_73156_b() {
        return false;
    }

    public String func_73148_d() {
        return null;
    }

    public boolean func_191062_e(int x, int z) {
        return false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGen5.setFrequency(0.015f);
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseGen5.getNoise((float)(cx * 16 + x), (float)(cz * 16 + z)) / (float)this.CRATER_PROB))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE + 15;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 180; y > 50; --y) {
                    if (Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }
}

