/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.network.packet;

import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledDimensionChange;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ACPacketSimple
extends PacketBase
implements Packet<INetHandler> {
    private GSEnumSimplePacket type;
    private List<Object> data;
    private static String spamCheckString;

    public ACPacketSimple() {
    }

    public ACPacketSimple(GSEnumSimplePacket packetType, int dimID, Object ... data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public ACPacketSimple(GSEnumSimplePacket packetType, World world, Object[] data) {
        this(packetType, GCCoreUtil.getDimensionID((World)world), Arrays.asList(data));
    }

    public ACPacketSimple(GSEnumSimplePacket packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info((String)"Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = GSEnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() > 0) {
                GCLog.severe((String)("AsmodeusCore packet length problem for packet type " + this.type.toString()));
            }
        }
        catch (Exception e) {
            System.err.println("[AsmodeusCore] Error handling simple packet type: " + this.type.toString() + " " + buffer.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayerSP playerBaseClient = null;
        GCPlayerStatsClient stats = null;
        if (player instanceof EntityPlayerSP) {
            playerBaseClient = (EntityPlayerSP)player;
            stats = GCPlayerStatsClient.get((Entity)playerBaseClient);
        }
        switch (this.type) {
            case C_UPDATE_DIMENSION_LIST: {
                if (!String.valueOf(this.data.get(0)).equals(PlayerUtil.getName((EntityPlayer)player))) break;
                String dimensionList = (String)this.data.get(1);
                if (ConfigManagerCore.enableDebug && !dimensionList.equals(spamCheckString)) {
                    GCLog.info((String)("DEBUG info: " + dimensionList));
                    spamCheckString = dimensionList;
                }
                String[] destinations = dimensionList.split("\\?");
                ArrayList possibleCelestialBodies = Lists.newArrayList();
                HashMap spaceStationData = Maps.newHashMap();
                for (String str : destinations) {
                    CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForName((String)str);
                    if (celestialBody == null && str.contains("$")) {
                        String[] values = str.split("\\$");
                        int homePlanetID = Integer.parseInt(values[4]);
                        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
                            if (satellite.getParentPlanet().getDimensionID() != homePlanetID) continue;
                            celestialBody = satellite;
                            break;
                        }
                        if (!spaceStationData.containsKey(homePlanetID)) {
                            spaceStationData.put(homePlanetID, new HashMap());
                        }
                        ((Map)spaceStationData.get(homePlanetID)).put(values[1], new GuiCelestialSelection.StationDataGUI(values[2], Integer.valueOf(Integer.parseInt(values[3]))));
                    }
                    if (celestialBody == null) continue;
                    possibleCelestialBodies.add(celestialBody);
                }
                if (FMLClientHandler.instance().getClient().field_71441_e == null) break;
                SpaceData data = new SpaceData();
                data.addToMap("rocket_tier", (int)((Integer)this.data.get(3)));
                data.addToMap("rocket_engine", (Object)SpaceData.Engine_Type.byID((Integer)this.data.get(4)));
                data.addToMap("rocket_count_fuel", (int)((Integer)this.data.get(5)));
                if (!(FMLClientHandler.instance().getClient().field_71462_r instanceof NewGuiCelestialSelection)) {
                    NewGuiCelestialSelection gui = new NewGuiCelestialSelection(false, possibleCelestialBodies, (Boolean)this.data.get(2), data);
                    gui.spaceStationMap = spaceStationData;
                    FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)gui);
                    break;
                }
                ((NewGuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).possibleBodies = possibleCelestialBodies;
                ((NewGuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).spaceStationMap = spaceStationData;
                NewGuiCelestialSelection cfr_ignored_0 = (NewGuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r;
                NewGuiCelestialSelection.data = data;
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
        switch (this.type) {
            case S_TELEPORT_ENTITY: {
                stats.setFuelLevel(((Integer)this.data.get(1)).intValue());
                TickHandlerServer.scheduleNewDimensionChange((ScheduledDimensionChange)new ScheduledDimensionChange(playerBase, ((Integer)this.data.get(0)).intValue()));
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer var1) {
        this.decodeInto((ByteBuf)var1);
    }

    public void func_148840_b(PacketBuffer var1) {
        this.encodeInto((ByteBuf)var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum GSEnumSimplePacket {
        C_UPDATE_DIMENSION_LIST(Side.CLIENT, String.class, String.class, Boolean.class, Integer.class, Integer.class, Integer.class),
        S_TELEPORT_ENTITY(Side.SERVER, Integer.class, Integer.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private GSEnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

