/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.interfaces.GuiManager;

public class TextBoxLogic {
    private String text;
    private int width;
    private int charLimit;
    private int widthLimit;
    private float widthMultiplier;
    private int cursorIndex;
    private int cursorPosition;
    private boolean dirtyCursor;

    public TextBoxLogic(int charLimit, int width) {
        this.charLimit = charLimit;
        this.width = width;
        this.widthMultiplier = 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void addText(GuiManager gui, String str) {
        String newText = this.text.substring(0, this.cursorIndex) + str + this.text.substring(this.cursorIndex);
        if (newText.length() <= this.charLimit) {
            this.text = newText;
            if ((float)gui.getStringWidth(newText) * this.widthMultiplier < (float)(this.width - 2)) {
                this.widthLimit = newText.length();
            } else if ((float)gui.getStringWidth(this.getDisplayText()) * this.widthMultiplier >= (float)(this.width - 2)) {
                --this.widthLimit;
            }
            this.moveCursor(gui, str.length());
            this.textChanged();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void deleteText(GuiManager gui, int direction) {
        if (this.cursorIndex + direction >= 0 && this.cursorIndex + direction <= this.text.length()) {
            if (direction > 0) {
                this.text = this.text.substring(0, this.cursorIndex) + this.text.substring(this.cursorIndex + 1);
            } else {
                this.text = this.text.substring(0, this.cursorIndex - 1) + this.text.substring(this.cursorIndex);
                this.moveCursor(gui, direction);
            }
            this.textChanged();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void moveCursor(GuiManager gui, int steps) {
        this.cursorIndex += steps;
        this.updateCursor();
    }

    protected void textChanged() {
    }

    public String getText() {
        return this.text;
    }

    public String getDisplayText() {
        return this.text.substring(MathHelper.func_76125_a((int)(this.text.length() - this.widthLimit), (int)0, (int)this.text.length()));
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getCursorPosition(GuiManager gui) {
        if (this.dirtyCursor) {
            this.cursorPosition = (int)((float)gui.getStringWidth(this.getDisplayText().substring(0, Math.min(this.cursorIndex, this.getDisplayText().length()))) * this.widthMultiplier);
            this.dirtyCursor = false;
        }
        return this.cursorPosition;
    }

    @SideOnly(value=Side.CLIENT)
    public void onKeyStroke(GuiManager gui, char c, int k) {
        if (k == 203) {
            this.moveCursor(gui, -1);
        } else if (k == 205) {
            this.moveCursor(gui, 1);
        } else if (k == 14) {
            this.deleteText(gui, -1);
        } else if (k == 211) {
            this.deleteText(gui, 1);
        } else if (ChatAllowedCharacters.func_71566_a((char)c)) {
            this.addText(gui, Character.toString(c));
        }
    }

    public void updateCursor() {
        if (this.cursorIndex < 0) {
            this.cursorIndex = 0;
        } else if (this.cursorIndex > this.getDisplayText().length()) {
            this.cursorIndex = this.text.length();
        }
        this.dirtyCursor = true;
    }

    public void setTextAndCursor(String s) {
        this.setText(s);
        this.resetCursor();
    }

    public void resetCursor() {
        this.cursorIndex = this.text.length();
        this.dirtyCursor = true;
    }

    public void setWidthMultiplier(float widthMultiplier) {
        this.widthMultiplier = widthMultiplier;
    }
}

