/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.api.tile.IRotatable;
import icbm.classic.content.explosive.blast.BlastTNT;
import icbm.classic.content.missile.EntityMissile;
import icbm.classic.lib.transform.vector.Pos;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastBreech
extends BlastTNT {
    private int depth;

    public BlastBreech(World world, Entity entity, double x, double y, double z, float size, int depth) {
        super(world, entity, x, y, z, size);
        this.damageToEntities = 13.0f;
        this.depth = depth;
    }

    @Override
    protected void calculateDamage() {
        if (this.depth <= 0) {
            super.calculateDamage();
        } else if (!this.world().field_72995_K) {
            EnumFacing direction = EnumFacing.DOWN;
            if (this.field_77283_e instanceof IRotatable) {
                direction = ((IRotatable)this.field_77283_e).getDirection().func_176734_d();
            } else if (this.field_77283_e != null) {
                direction = this.field_77283_e.field_70125_A > 45.0f ? (this.field_77283_e instanceof EntityMissile ? EnumFacing.UP : EnumFacing.DOWN) : (this.field_77283_e.field_70125_A < -45.0f ? (this.field_77283_e instanceof EntityMissile ? EnumFacing.DOWN : EnumFacing.UP) : this.field_77283_e.func_184172_bi());
            }
            for (int h = -1; h < 2; ++h) {
                block1: for (int w = -1; w < 2; ++w) {
                    float energy = 4.0f * this.field_77280_f + (float)(this.depth * 3);
                    for (int i = 0; i < this.depth; ++i) {
                        float e;
                        Pos p;
                        Pos dir = (Pos)new Pos(direction).multiply(i);
                        if (direction == EnumFacing.DOWN || direction == EnumFacing.UP) {
                            p = (Pos)dir.add(h, 0.0, w);
                        } else if (direction == EnumFacing.EAST || direction == EnumFacing.WEST) {
                            p = (Pos)dir.add(0.0, h, w);
                        } else if (direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH) {
                            p = (Pos)dir.add(w, h, 0.0);
                        } else {
                            return;
                        }
                        p = (Pos)new Pos((IPos3D)this).add(p);
                        IBlockState state = p.getBlockState((IBlockAccess)this.world());
                        Block block = state.func_177230_c();
                        if (!block.isAir(state, (IBlockAccess)this.world(), p.toBlockPos()) && (e = block.getExplosionResistance(this.world(), p.toBlockPos(), this.field_77283_e, (Explosion)this)) < 40.0f) {
                            energy -= e;
                            this.func_180343_e().add(p.toBlockPos());
                        }
                        if (energy <= 0.0f) continue block1;
                    }
                }
            }
            this.world().func_184148_a(null, this.location.x(), this.location.y(), this.location.z(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 5.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }
}

