/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.wrapper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.api.method.wrapper.ArgumentType;
import org.squiddev.plethora.core.PlethoraCore;

public final class ArgumentTypeRegistry {
    private static final Map<Class<?>, Field> fields = new HashMap();
    private static final Map<Class<?>, ArgumentType<?>> values = new HashMap();

    private ArgumentTypeRegistry() {
    }

    @Nullable
    static Field getField(Class<?> type) {
        return fields.get(type);
    }

    @Nullable
    static ArgumentType<?> get(Class<?> type) {
        return values.get(type);
    }

    public static boolean register(@Nonnull Class<?> klass, @Nonnull Field field) {
        Field existing = fields.get(klass);
        if (existing != null) {
            PlethoraCore.LOG.error("ArgumentType field {}.{} and {}.{} both have type {}. Only the first of these will be used.", (Object)existing.getDeclaringClass().getName(), (Object)existing.getName(), (Object)field.getDeclaringClass().getName(), (Object)field.getName(), (Object)klass.getName());
            return false;
        }
        fields.put(klass, field);
        try {
            values.put(klass, (ArgumentType)field.get(null));
        }
        catch (ReflectiveOperationException e) {
            PlethoraCore.LOG.error(String.format("ArgumentType field %s.%s's value could not be extracted.", field.getDeclaringClass().getName(), field.getName()), (Throwable)e);
            return false;
        }
        return true;
    }
}

