/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.appliedenergistics;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.meta.SimpleMetaProvider;
import org.squiddev.plethora.api.method.ContextHelpers;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.integration.vanilla.meta.MetaItemBasic;

@Injects(value="appliedenergistics2")
public final class MetaAppliedEnergistics {
    public static final SimpleMetaProvider<ICraftingCPU> META_CRAFTING_CPU = cpu -> {
        HashMap<String, Object> out = new HashMap<String, Object>(4);
        out.put("name", cpu.getName());
        out.put("busy", cpu.isBusy());
        out.put("coprocessors", cpu.getCoProcessors());
        out.put("storage", cpu.getAvailableStorage());
        return out;
    };
    public static final IMetaProvider<IAEItemStack> META_AE_ITEM_STACK = new BasicMetaProvider<IAEItemStack>("An ItemStack within an AE network."){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IAEItemStack stack) {
            return Collections.singletonMap("count", stack.getStackSize());
        }

        @Override
        @Nullable
        public IAEItemStack getExample() {
            return (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)new ItemStack(Items.field_151055_y, 4));
        }
    };
    public static final BaseMetaProvider<ICraftingPatternDetails> META_CRAFTING_PATTERN_DETAILS = new BaseMetaProvider<ICraftingPatternDetails>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<ICraftingPatternDetails> context) {
            ICraftingPatternDetails pattern = context.getTarget();
            HashMap<String, Object> out = new HashMap<String, Object>(4);
            out.put("outputs", ContextHelpers.getMetaList(context, pattern.getOutputs()));
            out.put("inputs", ContextHelpers.getMetaList(context, pattern.getInputs()));
            out.put("canSubstitute", pattern.canSubstitute());
            out.put("priority", pattern.getPriority());
            return out;
        }
    };

    private MetaAppliedEnergistics() {
    }

    @Nonnull
    static HashMap<String, Object> getItemStackProperties(@Nonnull IAEItemStack stack) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.putAll(MetaItemBasic.getBasicMeta(stack.getDefinition()));
        data.put("count", stack.getStackSize());
        data.put("isCraftable", stack.isCraftable());
        return data;
    }
}

