/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;

public class DeleteChunkSubCommand
extends BasePregenCommand {
    public DeleteChunkSubCommand() {
        super(4);
        this.addDescription(0, "X Position: The X Chunk Position of the Deletion. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(1, "Z Position: The Z Chunk Position of the Deletion. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "(Optional) Dimension: The Dimension the Deletion should be happening in");
        this.addDescription(3, "(Optional) Delay: How long the Deleter should wait until it should start (in ticks)");
        this.addSuggestion("deleteChunk 100 200", "Deletes a Unloaded Chunk at X100 Z200 at the Dimension that the sender is at");
    }

    @Override
    public String getName() {
        return "deleteChunk";
    }

    @Override
    public String getDescription() {
        return "Deletes a Single Unloaded Chunk";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 2) {
            FilePos position = DeleteChunkSubCommand.getChunkPos(args[0], args[1], container.getPlayerPos());
            int dimension = DeleteChunkSubCommand.getDimension(container, DeleteChunkSubCommand.getArg(args, 2));
            int delay = DeleteChunkSubCommand.parseNumber(DeleteChunkSubCommand.getArg(args, 3), 0);
            if (!DeleteChunkSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            container.onProcessStarted();
            container.getDeleter().startTask(new SingleDeletion(dimension, position, delay));
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0 || commandIndex == 1) {
            return DeleteChunkSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 2) {
            return DeleteChunkSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 3) {
            return DeleteChunkSubCommand.getBestMatch(args, CompleterHelper.GEN_DELAY);
        }
        return new ArrayList<String>();
    }

    private Map<FilePos, Set<FilePos>> createTask(FilePos pos) {
        LinkedHashMap<FilePos, Set<FilePos>> map = new LinkedHashMap<FilePos, Set<FilePos>>();
        LinkedHashSet<FilePos> file = new LinkedHashSet<FilePos>();
        file.add(pos);
        map.put(pos.toChunkFile(), file);
        return map;
    }

    public static class SingleDeletion
    extends IDeletionTask {
        int dim;
        FilePos position;

        public SingleDeletion(int dimension, FilePos pos, int delay) {
            super(delay);
            this.dim = dimension;
            this.position = pos;
        }

        @Override
        public DeleteProcess createTask() {
            boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            WorldServer world = this.getWorld(this.dim);
            DeleteProcess process = new DeleteProcess(world.getChunkSaveLocation(), this.createTask(this.position));
            if (loaded) {
                process.setChunkHost(world);
            } else {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return process;
        }

        private Map<FilePos, Set<FilePos>> createTask(FilePos pos) {
            LinkedHashMap<FilePos, Set<FilePos>> map = new LinkedHashMap<FilePos, Set<FilePos>>();
            LinkedHashSet<FilePos> file = new LinkedHashSet<FilePos>();
            file.add(pos);
            map.put(pos.toChunkFile(), file);
            return map;
        }
    }
}

