/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.shared.gui;

import com.google.common.collect.Lists;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.vc.shared.gui.GuiButtonNop;
import noppes.vc.shared.gui.GuiContainerBasic;
import noppes.vc.shared.gui.GuiHoverText;
import noppes.vc.shared.gui.GuiLabel;
import noppes.vc.shared.gui.GuiScroll;
import noppes.vc.shared.gui.GuiSliderNop;
import noppes.vc.shared.gui.GuiTextFieldNop;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public abstract class GuiBasic
extends GuiScreen {
    public static Window AWTWindow;
    public EntityPlayerSP player;
    public boolean drawDefaultBackground = true;
    private Map<Integer, GuiButtonNop> buttons = new ConcurrentHashMap<Integer, GuiButtonNop>();
    private Map<Integer, GuiTextFieldNop> textfields = new ConcurrentHashMap<Integer, GuiTextFieldNop>();
    private Map<Integer, GuiLabel> labels = new ConcurrentHashMap<Integer, GuiLabel>();
    private Map<Integer, GuiScroll> scrolls = new ConcurrentHashMap<Integer, GuiScroll>();
    private Map<Integer, GuiSliderNop> sliders = new ConcurrentHashMap<Integer, GuiSliderNop>();
    private Map<Integer, GuiScreen> extra = new ConcurrentHashMap<Integer, GuiScreen>();
    public String title;
    public ResourceLocation background = null;
    public boolean closeOnEsc = false;
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;
    private GuiBasic subgui;
    private int subguiId;
    public GuiScreen parent;
    public int mouseX;
    public int mouseY;
    public float bgScale = 1.0f;
    private GuiButton selectedButton;

    public GuiBasic() {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.title = "";
        this.xSize = 200;
        this.ySize = 222;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146296_j = this.field_146297_k.func_175599_af();
        this.field_146289_q = this.field_146297_k.field_71466_p;
    }

    public void setBackground(String texture) {
        this.background = new ResourceLocation("variedcommodities", "textures/gui/" + texture);
    }

    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("variedcommodities", "textures/gui/" + texture);
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.initPacket();
    }

    public void initPacket() {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiTextFieldNop.unfocus();
        if (this.subgui != null) {
            this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            this.subgui.func_73866_w_();
        }
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n = Lists.newArrayList();
        this.buttons = new ConcurrentHashMap<Integer, GuiButtonNop>();
        this.textfields = new ConcurrentHashMap<Integer, GuiTextFieldNop>();
        this.labels = new ConcurrentHashMap<Integer, GuiLabel>();
        this.scrolls = new ConcurrentHashMap<Integer, GuiScroll>();
        this.sliders = new ConcurrentHashMap<Integer, GuiSliderNop>();
        this.extra = new ConcurrentHashMap<Integer, GuiScreen>();
    }

    public void func_73876_c() {
        if (this.subgui != null) {
            this.subgui.func_73876_c();
        } else {
            for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.textfields.values())) {
                if (!tf.enabled) continue;
                tf.func_146178_a();
            }
            super.func_73876_c();
        }
    }

    public void addExtra(GuiHoverText gui) {
        gui.func_146280_a(this.field_146297_k, 350, 250);
        this.extra.put(gui.id, gui);
    }

    public void func_73864_a(int i, int j, int k) {
        if (AWTWindow != null) {
            return;
        }
        if (this.subgui != null) {
            this.subgui.func_73864_a(i, j, k);
        } else {
            for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.textfields.values())) {
                if (!tf.enabled) continue;
                tf.func_146192_a(i, j, k);
            }
            this.mouseEvent(i, j, k);
            if (k == 0) {
                for (GuiScroll scroll : new ArrayList<GuiScroll>(this.scrolls.values())) {
                    scroll.func_73864_a(i, j, k);
                }
                for (GuiButton guibutton : this.field_146292_n) {
                    if (!guibutton.func_146116_c(this.field_146297_k, this.mouseX, this.mouseY)) continue;
                    GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                    this.selectedButton = guibutton = event.getButton();
                    guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                    this.func_146284_a(guibutton);
                    if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) break;
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
                    break;
                }
            }
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.selectedButton != null && state == 0) {
            this.selectedButton.func_146118_a(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    public void mouseEvent(int i, int j, int k) {
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.subgui != null) {
            this.subgui.buttonEvent(guibutton);
        } else {
            this.buttonEvent(guibutton);
        }
    }

    public void buttonEvent(GuiButton guibutton) {
    }

    public void func_73869_a(char c, int i) {
        if (AWTWindow != null) {
            return;
        }
        if (this.subgui != null) {
            this.subgui.func_73869_a(c, i);
        }
        for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.textfields.values())) {
            tf.func_146201_a(c, i);
        }
        if (this.closeOnEsc && (i == 1 || !GuiTextFieldNop.isActive() && this.isInventoryKey(i))) {
            this.close();
        }
    }

    public void func_146281_b() {
        GuiTextFieldNop.unfocus();
    }

    public void close() {
        if (this.parent != null) {
            this.save();
            if (this.parent instanceof GuiBasic) {
                ((GuiBasic)this.parent).closeSubGui();
            }
            if (this.parent instanceof GuiContainerBasic) {
                ((GuiContainerBasic)this.parent).closeSubGui();
            }
        } else {
            this.displayGuiScreen(null);
            this.field_146297_k.func_71381_h();
            this.save();
        }
    }

    public void addButton(GuiButtonNop button) {
        this.buttons.put(button.field_146127_k, button);
        this.field_146292_n.add(button);
    }

    public GuiButtonNop getButton(int i) {
        return this.buttons.get(i);
    }

    public void addTextField(GuiTextFieldNop tf) {
        this.textfields.put(tf.field_175208_g, tf);
    }

    public GuiTextFieldNop getTextField(int i) {
        return this.textfields.get(i);
    }

    public void addLabel(GuiLabel label) {
        this.labels.put(label.id, label);
    }

    public GuiLabel getLabel(int i) {
        return this.labels.get(i);
    }

    public void addSlider(GuiSliderNop slider) {
        this.sliders.put(slider.field_146127_k, slider);
        this.field_146292_n.add(slider);
    }

    public GuiSliderNop getSlider(int i) {
        return this.sliders.get(i);
    }

    public void addScroll(GuiScroll scroll) {
        scroll.func_146280_a(this.field_146297_k, 350, 250);
        this.scrolls.put(scroll.id, scroll);
    }

    public GuiScroll getScroll(int id) {
        return this.scrolls.get(id);
    }

    public abstract void save();

    public void func_73863_a(int i, int j, float f) {
        if (AWTWindow != null) {
            if (!AWTWindow.isVisible()) {
                AWTWindow.dispose();
                AWTWindow = null;
            } else if (Display.isActive()) {
                Toolkit.getDefaultToolkit().beep();
                AWTWindow.setVisible(true);
            }
        }
        this.mouseX = i;
        this.mouseY = j;
        if (this.drawDefaultBackground && this.subgui == null) {
            this.func_146276_q_();
        }
        if (this.background != null && this.field_146297_k.field_71446_o != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            GlStateManager.func_179152_a((float)this.bgScale, (float)this.bgScale, (float)this.bgScale);
            this.field_146297_k.field_71446_o.func_110577_a(this.background);
            if (this.xSize > 256) {
                this.func_73729_b(0, 0, 0, 0, 250, this.ySize);
                this.func_73729_b(250, 0, 256 - (this.xSize - 250), 0, this.xSize - 250, this.ySize);
            } else {
                this.func_73729_b(0, 0, 0, 0, this.xSize, this.ySize);
            }
            GlStateManager.func_179121_F();
        }
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        for (GuiLabel label : new ArrayList<GuiLabel>(this.labels.values())) {
            label.drawLabel(this, this.field_146289_q);
        }
        for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.textfields.values())) {
            tf.drawTextBox(i, j);
        }
        for (GuiScroll scroll : new ArrayList<GuiScroll>(this.scrolls.values())) {
            scroll.drawScreen(i, j, f, !this.hasSubGui() && scroll.isMouseOver(i, j) ? Mouse.getDWheel() : 0);
        }
        for (GuiScreen gui : new ArrayList<GuiScreen>(this.extra.values())) {
            gui.func_73863_a(i, j, f);
        }
        super.func_73863_a(i, j, f);
        if (this.subgui != null) {
            this.subgui.func_73863_a(i, j, f);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void elementClicked() {
        if (this.subgui != null) {
            this.subgui.elementClicked();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void doubleClicked() {
    }

    public boolean isInventoryKey(int i) {
        return i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
    }

    public void func_146276_q_() {
        super.func_146276_q_();
    }

    public void displayGuiScreen(GuiScreen gui) {
        this.field_146297_k.func_147108_a(gui);
    }

    public void setSubGui(int id, GuiBasic gui) {
        if (this.subgui != null) {
            this.closeSubGui();
        }
        this.subguiId = id;
        this.subgui = gui;
        this.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.subgui.parent = this;
        this.func_73866_w_();
    }

    public void closeSubGui() {
        if (this instanceof ISubGuiListener) {
            ((ISubGuiListener)((Object)this)).subGuiClosed(this.subguiId, this.subgui);
        }
        this.subgui = null;
    }

    public boolean hasSubGui() {
        return this.subgui != null;
    }

    public GuiBasic getSubGui() {
        if (this.hasSubGui() && this.subgui.hasSubGui()) {
            return this.subgui.getSubGui();
        }
        return this.subgui;
    }

    public void openLink(String link) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(link));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface IGuiData {
        public void setGuiData(NBTTagCompound var1);
    }

    public static interface ISubGuiListener {
        public void subGuiClosed(int var1, GuiBasic var2);
    }
}

