/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.render.modelspec;

import java.util.List;
import java.util.Objects;
import net.machinemuse.numina.client.render.modelspec.ModelSpec;
import net.machinemuse.numina.client.render.modelspec.PartSpecBase;
import net.machinemuse.numina.client.render.modelspec.SpecBinding;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelPartSpec
extends PartSpecBase {
    private final boolean defaultglow;

    public ModelPartSpec(ModelSpec modelSpec, SpecBinding binding, String partName, Integer defaultcolourindex, Boolean defaultglow) {
        super(modelSpec, binding, partName, defaultcolourindex);
        this.defaultglow = defaultglow != null ? defaultglow : false;
    }

    @Override
    public String getDisaplayName() {
        return I18n.func_135052_a((String)("model." + this.spec.getOwnName() + "." + this.partName + ".partName"), (Object[])new Object[0]);
    }

    public boolean getGlow() {
        return this.defaultglow;
    }

    public boolean getGlow(NBTTagCompound nbt) {
        return nbt.func_74764_b("glow") ? nbt.func_74767_n("glow") : this.defaultglow;
    }

    public void setGlow(NBTTagCompound nbt, boolean g) {
        if (g == this.defaultglow) {
            nbt.func_82580_o("glow");
        } else {
            nbt.func_74757_a("glow", g);
        }
    }

    public List<BakedQuad> getQuads() {
        return ((ModelSpec)this.spec).getModel().getQuadsforPart(this.partName);
    }

    public NBTTagCompound multiSet(NBTTagCompound nbt, Integer colourIndex, Boolean glow) {
        super.multiSet(nbt, colourIndex);
        this.setGlow(nbt, glow != null ? glow : false);
        return nbt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelPartSpec that = (ModelPartSpec)o;
        return this.defaultglow == that.defaultglow;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultglow);
    }
}

