/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.entities;

import asmodeuscore.core.astronomy.SpaceData;
import galaxyspace.core.GSBlocks;
import galaxyspace.core.GSItems;
import galaxyspace.core.prefab.entities.EntityTieredRocketWithEngine;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.BlockAdvancedLandingPadFull;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityTier5Rocket
extends EntityTieredRocketWithEngine {
    public EntityTier5Rocket(World par1World) {
        super(par1World, 5);
        this.func_70105_a(2.2f, 11.0f);
    }

    public EntityTier5Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6, 5, rocketType);
        this.rocketType = rocketType;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public EntityTier5Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType, SpaceData.Engine_Type engine) {
        super(par1World, par2, par4, par6, 5, rocketType);
        this.setEngine(engine);
    }

    @Override
    public double func_70033_W() {
        return 1.5;
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(GSItems.ROCKET_TIER_5, 1, this.rocketType.getIndex());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public double func_70042_X() {
        return 0.75;
    }

    @Override
    public float getRotateOffset() {
        return 0.25f;
    }

    @Override
    public double getOnPadYOffset() {
        return 0.0;
    }

    public void onLaunch() {
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            GCPlayerStats stats = null;
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity player : this.func_184188_bt()) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    stats = GCPlayerStats.get((Entity)player);
                    stats.setLaunchpadStack(null);
                    if (this.field_70170_p.field_73011_w instanceof IOrbitDimension) continue;
                    stats.setCoordsTeleportedFromX(player.field_70165_t);
                    stats.setCoordsTeleportedFromZ(player.field_70161_v);
                }
                Entity playerMain = (Entity)this.func_184188_bt().get(0);
                if (playerMain instanceof EntityPlayerMP) {
                    stats = GCPlayerStats.get((Entity)playerMain);
                }
            }
            int amountRemoved = 0;
            block1: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 2; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 2; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 2; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 2; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == null || !(block instanceof BlockAdvancedLandingPadFull) || amountRemoved >= 25) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, pos);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block1;
                        this.field_70170_p.func_175698_g(pos);
                        amountRemoved = 25;
                        break block1;
                    }
                }
            }
            if (stats != null && amountRemoved == 25) {
                stats.setLaunchpadStack(new ItemStack(GSBlocks.ADVANCED_LANDING_PAD_SINGLE, 25, 0));
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.func_177956_o();
                modifier = Math.max(modifier, 180.0);
                x1 *= modifier / 200.0;
                y1 *= Math.min(modifier / 200.0, 2.5);
                z1 *= modifier / 200.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - 0.75 * this.field_70181_x - 0.3 + 1.2;
            double x2 = this.field_70165_t + x1 + this.field_70159_w;
            double z2 = this.field_70161_v + z1 + this.field_70179_y;
            Vector3 motionVec = new Vector3(x1 + this.field_70159_w, y1 + this.field_70181_x, z1 + this.field_70179_y);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d5 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 d6 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 d7 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 d8 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(270.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            Vector3 mv5 = motionVec.clone().translate(d5);
            Vector3 mv6 = motionVec.clone().translate(d6);
            Vector3 mv7 = motionVec.clone().translate(d7);
            Vector3 mv8 = motionVec.clone().translate(d8);
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched());
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched());
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched());
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched());
            this.makeFlame(x2 + d5.x, y2 + d5.y, z2 + d5.z, mv5, this.getLaunched());
            this.makeFlame(x2 + d6.x, y2 + d6.y, z2 + d6.z, mv6, this.getLaunched());
            this.makeFlame(x2 + d7.x, y2 + d7.y, z2 + d7.z, mv7, this.getLaunched());
            this.makeFlame(x2 + d8.x, y2 + d8.y, z2 + d8.z, mv8, this.getLaunched());
            this.makeFlame(x2, y2, z2, new Vector3(x1, y1, z1), this.getLaunched());
        }
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched) {
        EntityLivingBase riddenByEntity;
        EntityLivingBase entityLivingBase = riddenByEntity = this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityLivingBase) ? null : (EntityLivingBase)this.func_184188_bt().get(0);
        if (getLaunched) {
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, new Object[]{riddenByEntity});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, new Object[]{riddenByEntity});
            return;
        }
        if (this.field_70173_aa % 2 == 0) {
            return;
        }
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2 += 1.6, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.1 + this.field_70146_Z.nextDouble() / 10.0, y1 - 0.3, z1 - 0.1 - this.field_70146_Z.nextDouble() / 10.0), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.3, y1 - 0.3, z1), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.3, y1 - 0.3, z1), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.3), new Object[]{riddenByEntity});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.3), new Object[]{riddenByEntity});
    }

    @Override
    public int getFuelTankCapacity() {
        return 2800;
    }

    @Override
    public float getRenderOffsetY() {
        return -0.15f;
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityAdvLandingPad;
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        return GSUtils.fillWithGCFuel(this.fuelTank, liquid, doFill, this);
    }
}

