/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.common.CommonProxy;
import cpw.mods.ironchest.common.config.Config;
import cpw.mods.ironchest.common.lib.BlockLists;
import cpw.mods.ironchest.common.network.MessageCrystalChestSync;
import cpw.mods.ironchest.common.network.MessageCrystalShulkerSync;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityCopperChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityCrystalChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityDiamondChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityDirtChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityGoldChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityIronChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityObsidianChest;
import cpw.mods.ironchest.common.tileentity.chest.TileEntitySilverChest;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityCopperShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityCrystalShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityDiamondShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityGoldShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityObsidianShulkerBox;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntitySilverShulkerBox;
import cpw.mods.ironchest.common.util.MissingMappingsHandler;
import cpw.mods.ironchest.common.util.OcelotsSitOnChestsHandler;
import java.util.Properties;
import net.minecraft.util.datafix.DataFixer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ironchest", name="Iron Chests", dependencies="required-after:forge@[14.21.0.2359,)", acceptedMinecraftVersions="[1.12, 1.13)")
public class IronChest {
    public static final String MOD_ID = "ironchest";
    @Mod.Instance(value="ironchest")
    public static IronChest instance;
    @SidedProxy(clientSide="cpw.mods.ironchest.client.ClientProxy", serverSide="cpw.mods.ironchest.common.CommonProxy")
    public static CommonProxy proxy;
    public static final SimpleNetworkWrapper packetHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Properties properties = event.getVersionProperties();
        if (properties != null) {
            String major = properties.getProperty("IronChest.build.major.number");
            String minor = properties.getProperty("IronChest.build.minor.number");
            String rev = properties.getProperty("IronChest.build.revision.number");
            String build = properties.getProperty("IronChest.build.number");
            event.getModMetadata().version = String.format("%s.%s.%s build %s", major, minor, rev, build);
        }
        Config.load(event);
        proxy.preInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new OcelotsSitOnChestsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MissingMappingsHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int messageId = 0;
        packetHandler.registerMessage(MessageCrystalChestSync.Handler.class, MessageCrystalChestSync.class, messageId++, Side.CLIENT);
        packetHandler.registerMessage(MessageCrystalShulkerSync.Handler.class, MessageCrystalShulkerSync.class, messageId++, Side.CLIENT);
        BlockLists.createShulkerItemList();
        this.registerDataFixes();
    }

    public void registerDataFixes() {
        CompoundDataFixer dataFixer = FMLCommonHandler.instance().getDataFixer();
        TileEntityIronChest.registerFixesChest((DataFixer)dataFixer);
        TileEntityGoldChest.registerFixesChest((DataFixer)dataFixer);
        TileEntityDiamondChest.registerFixesChest((DataFixer)dataFixer);
        TileEntityCrystalChest.registerFixesChest((DataFixer)dataFixer);
        TileEntitySilverChest.registerFixesChest((DataFixer)dataFixer);
        TileEntityCopperChest.registerFixesChest((DataFixer)dataFixer);
        TileEntityObsidianChest.registerFixesChest((DataFixer)dataFixer);
        TileEntityDirtChest.registerFixesChest((DataFixer)dataFixer);
        TileEntityIronShulkerBox.registerFixesShulkerBox((DataFixer)dataFixer);
        TileEntityGoldShulkerBox.registerFixesShulkerBox((DataFixer)dataFixer);
        TileEntityDiamondShulkerBox.registerFixesShulkerBox((DataFixer)dataFixer);
        TileEntityCrystalShulkerBox.registerFixesShulkerBox((DataFixer)dataFixer);
        TileEntitySilverShulkerBox.registerFixesShulkerBox((DataFixer)dataFixer);
        TileEntityCopperShulkerBox.registerFixesShulkerBox((DataFixer)dataFixer);
        TileEntityObsidianShulkerBox.registerFixesShulkerBox((DataFixer)dataFixer);
    }

    static {
        packetHandler = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
    }
}

