/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.capability.AbstractCapabilityDataMP;
import stevekung.mods.moreplanets.tileentity.TileEntitySpacePortal;
import stevekung.mods.moreplanets.utils.blocks.BlockBreakableMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.utils.client.renderer.IItemModelRender;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public class BlockSpacePortal
extends BlockBreakableMP
implements IItemModelRender,
ITileEntityProvider {
    public BlockSpacePortal(String name) {
        super(Material.field_151576_e);
        this.func_149752_b(2000.0f);
        this.func_149711_c(35.0f);
        this.func_149663_c(name);
        this.func_149715_a(0.75f);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityPlayer player;
        if (entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_184218_aH() && !player.func_184207_aI() && player.func_184222_aU()) {
            AbstractCapabilityDataMP data = AbstractCapabilityDataMP.get((Entity)player);
            if (data.getTimeUntilPortal() > 0) {
                data.setTimeUntilPortal(player.func_82147_ab());
            } else {
                data.setInPortal(true);
            }
        }
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean moveEntity) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int k;
        if (rand.nextInt(20) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        double d0 = (float)pos.func_177958_n() + rand.nextFloat();
        double d1 = (float)pos.func_177956_o() + rand.nextFloat();
        double d2 = (float)pos.func_177952_p() + rand.nextFloat();
        double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
        double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
        double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
        int j = rand.nextInt(2) * 2 - 1;
        for (k = 0; k < 16; ++k) {
            d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
            d5 = rand.nextFloat() * 2.0f * (float)j;
            world.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
        for (k = 0; k < 16; ++k) {
            d2 = (float)pos.func_177952_p() + rand.nextFloat();
            d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
            d3 = rand.nextFloat() * 2.0f * (float)j;
            world.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySpacePortal();
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.MACHINE_BLOCK;
    }

    @Override
    protected boolean isTranslucent() {
        return true;
    }

    @Override
    protected boolean renderSideWithState() {
        return false;
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return ColorUtils.stringToRGB((String)"124, 124, 124");
    }
}

