/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import com.google.common.base.Predicate;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyStorageCluster;
import stevekung.mods.moreplanets.tileentity.TileEntityNuclearWasteEnergyStorageCluster;
import stevekung.mods.moreplanets.utils.BlocksItemsRegistry;
import stevekung.mods.moreplanets.utils.IDescription;
import stevekung.mods.moreplanets.utils.ItemDescription;
import stevekung.mods.moreplanets.utils.blocks.BlockTileMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityEnergyStorageClusterMP;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public class BlockTieredEnergyStorageCluster
extends BlockTileMP
implements IDescription {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final PropertyInteger VALUE = PropertyInteger.func_177719_a((String)"value", (int)0, (int)16);
    public static final IMachineSidesProperties MACHINESIDES_RENDERTYPE = IMachineSidesProperties.TWOFACES_HORIZ;
    private static final PropertyEnum<IMachineSidesProperties.MachineSidesModel> SIDES = BlockTieredEnergyStorageCluster.MACHINESIDES_RENDERTYPE.asProperty;
    private final BlockType type;

    public BlockTieredEnergyStorageCluster(String name, BlockType type) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149663_c(name);
        this.type = type;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        world.func_180501_a(pos, this.func_176203_a(change), 3);
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("EnergyStored") && world.func_175625_s(pos) instanceof TileEntityEnergyStorageClusterMP) {
            TileEntityEnergyStorageClusterMP electric = (TileEntityEnergyStorageClusterMP)world.func_175625_s(pos);
            electric.storage.setEnergyStored(itemStack.func_77978_p().func_74760_g("EnergyStored"));
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        player.func_71020_j(0.025f);
        if (tile instanceof TileEntityEnergyStorageClusterMP) {
            ItemStack machine = new ItemStack((Block)this, 1, 0);
            TileEntityEnergyStorageClusterMP electric = (TileEntityEnergyStorageClusterMP)tile;
            if (electric.getEnergyStoredGC() > 0.0f) {
                machine.func_77982_d(new NBTTagCompound());
                machine.func_77978_p().func_74776_a("EnergyStored", electric.getEnergyStoredGC());
            }
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)machine);
        }
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)MorePlanetsMod.INSTANCE, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this.type == BlockType.DARK_ENERGY_STORAGE_CLUSTER) {
            return new TileEntityDarkEnergyStorageCluster();
        }
        return new TileEntityNuclearWasteEnergyStorageCluster();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta % 4));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VALUE, SIDES});
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.MACHINE_BLOCK;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        state = IMachineSides.addPropertyForTile((IBlockState)state, (TileEntity)tile, (IMachineSidesProperties)MACHINESIDES_RENDERTYPE, SIDES);
        if (tile instanceof TileEntityEnergyStorageClusterMP) {
            TileEntityEnergyStorageClusterMP storageModule = (TileEntityEnergyStorageClusterMP)tile;
            return state.func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(storageModule.scaledEnergyLevel));
        }
        return state.func_177226_a((IProperty)VALUE, (Comparable)Integer.valueOf(0));
    }

    public boolean onSneakUseWrench(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IMachineSides) {
            ((IMachineSides)tile).nextSideConfiguration(tile);
            return true;
        }
        return false;
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(BlocksItemsRegistry.getDescription(this.type.toString() + ".description"));
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return ColorUtils.stringToRGB((String)"124, 124, 124");
    }

    public static enum BlockType {
        DARK_ENERGY_STORAGE_CLUSTER,
        NUCLEAR_WASTE_ENERGY_STORAGE_CLUSTER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

