/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.client.gui.GuiListCelestialSelection;
import stevekung.mods.moreplanets.client.gui.GuiListCelestialSelectionEntry;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.utils.dimension.IDarkEnergyProvider;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

@SideOnly(value=Side.CLIENT)
public class GuiCelestialSelection
extends GuiScreen {
    private GuiButton doneButton;
    private GuiButton azButton;
    private GuiTextField searchField;
    private GuiListCelestialSelection selectionList;
    private String lastFilterText = "";
    private List<CelestialBody> listCelestial = new ArrayList<CelestialBody>();

    public void func_73866_w_() {
        this.listCelestial.clear();
        this.listCelestial.addAll(GalaxyRegistry.getRegisteredPlanets().values().stream().filter(planet -> planet.getDimensionID() != 0 && planet.getDimensionID() != ConfigManagerMP.moreplanets_dimension.idDimensionSpaceNether).collect(Collectors.toList()));
        this.listCelestial.addAll(GalaxyRegistry.getRegisteredMoons().values());
        this.selectionList = new GuiListCelestialSelection(this, this.listCelestial, this.field_146294_l, this.field_146295_m, 48, this.field_146295_m - 32, 36);
        this.doneButton = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 32, this.field_146295_m - 26, 150, 20, LangUtils.translate((String)"gui.done")));
        this.doneButton.field_146124_l = false;
        this.azButton = new GuiButton(SortType.A_TO_Z.id, this.field_146294_l / 2 - 205, 26, 40, 20, "A-Z");
        this.func_189646_b(this.azButton);
        this.azButton.field_146124_l = false;
        this.func_189646_b(new GuiButton(SortType.Z_TO_A.id, this.field_146294_l / 2 - 164, 26, 40, 20, "Z-A"));
        this.func_189646_b(new GuiButton(SortType.REACHALBLE.id, this.field_146294_l / 2 - 123, 26, 60, 20, "Reachable"));
        this.func_189646_b(new GuiButton(SortType.TIER.id, this.field_146294_l / 2 - 62, 26, 40, 20, "Tier"));
        this.searchField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 150, this.field_146295_m - 26, 100, 14);
        this.searchField.func_146195_b(true);
        this.searchField.func_146205_d(true);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchField.func_146178_a();
        if (!this.searchField.func_146179_b().equals(this.lastFilterText)) {
            this.lastFilterText = this.searchField.func_146179_b();
            this.selectionList.refreshListSearch(this.lastFilterText);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.selectionList.func_178039_p();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.searchField.func_146201_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            SortType type;
            GuiListCelestialSelectionEntry entry = this.selectionList.getSelectedCelestial();
            if (button.field_146127_k == 0 && entry != null) {
                entry.teleport();
                this.field_146297_k.func_147108_a(null);
            }
            if ((type = SortType.getTypeForButton(button)) != null) {
                for (GuiButton buttonType : this.field_146292_n) {
                    if (SortType.getTypeForButton(buttonType) == null) continue;
                    buttonType.field_146124_l = true;
                }
                button.field_146124_l = false;
                this.selectionList.refreshList(type);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        LinkedList<String> infoList = new LinkedList<String>();
        if (this.selectionList != null) {
            this.selectionList.func_148128_a(mouseX, mouseY, partialTicks);
            this.func_73732_a(this.field_146289_q, "Select Celestial", this.field_146294_l / 2, 15, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, LangUtils.translate((String)"fml.menu.mods.search"), this.field_146294_l / 2 - 173, this.field_146295_m - 23, 0xFFFFFF);
            for (int i = 0; i < this.selectionList.func_148127_b(); ++i) {
                block23: {
                    if (!this.selectionList.func_148131_a(i)) continue;
                    CelestialBody celestial = this.selectionList.getSelectedCelestial().getCelestialBody();
                    infoList.add(ColorUtils.stringToRGB((String)"149, 200, 237").toColoredFont() + "Basic Information:");
                    try {
                        if (celestial.getDimensionID() != -1) {
                            Object space;
                            WorldProvider provider = WorldUtil.getProviderForDimensionClient((int)celestial.getDimensionID());
                            if (provider instanceof WorldProviderSpace) {
                                space = (WorldProviderSpace)provider;
                                String thermal = "";
                                try {
                                    thermal = String.valueOf(String.format("%.2f", Float.valueOf(1.8f * space.getThermalLevelModifier() * 32.0f))) + "\u2103";
                                }
                                catch (Exception e) {
                                    thermal = TextFormatting.RED + "Unknown";
                                }
                                if (space.getDayLength() <= 0L) {
                                    infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Day-night Cycle:", "No day-night cycle"));
                                } else {
                                    double dayDouble = space.getDayLength() / 24000L;
                                    if (dayDouble % 1.0 == 0.0) {
                                        int dayInt = (int)(space.getDayLength() / 24000L);
                                        infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Day-night Cycle:", dayInt + (dayInt == 1 ? " Day" : " Days") + " / " + dayInt * 24 + " hours"));
                                    } else {
                                        infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Day-night Cycle:", dayDouble + (dayDouble <= 1.0 ? " Day" : " Days") + " / " + dayDouble * 24.0 + " hours"));
                                    }
                                }
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Gravity:", String.valueOf(space.getGravity()) + "g"));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Wind:", String.valueOf(String.format("%.1f", Float.valueOf(space.getWindLevel() * 100.0f))) + "%"));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Thermal:", thermal));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Breathable Atmosphere:", space.hasBreathableAtmosphere()));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Corrode Armor:", space.shouldCorrodeArmor()));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Sound Reduction:", String.valueOf(space.getSoundVolReductionAmount() / 1.0f) + "%"));
                            }
                            if (provider instanceof ISolarLevel) {
                                ISolarLevel solar = (ISolarLevel)provider;
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Solar Level:", String.valueOf(String.format("%.1f", solar.getSolarEnergyMultiplier() * 100.0)) + "%"));
                            }
                            if (provider instanceof IDarkEnergyProvider) {
                                space = (IDarkEnergyProvider)provider;
                                String darkEnergy = "";
                                try {
                                    darkEnergy = String.valueOf(space.getDarkEnergyMultiplier(null, null)) + "%";
                                }
                                catch (Exception e) {
                                    darkEnergy = TextFormatting.RED + "Unstable Dark Energy";
                                }
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Dark Energy Level:", darkEnergy));
                            }
                            if (celestial instanceof Planet) {
                                Planet planet = (Planet)celestial;
                                if (!planet.atmosphere.composition.isEmpty()) {
                                    infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Gas:", String.valueOf(planet.atmosphere.composition)));
                                }
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Solar System:", planet.getParentSolarSystem().getLocalizedName()));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Galaxy:", planet.getParentSolarSystem().getLocalizedParentGalaxyName()));
                                if (!GalaxyRegistry.getMoonsForPlanet((Planet)planet).isEmpty()) {
                                    infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Number of Moons:", String.valueOf(GalaxyRegistry.getMoonsForPlanet((Planet)planet).size())));
                                }
                            } else if (celestial instanceof Moon) {
                                Moon moon = (Moon)celestial;
                                if (!moon.atmosphere.composition.isEmpty()) {
                                    infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Gas:", String.valueOf(moon.atmosphere.composition)));
                                }
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Solar System:", moon.getParentPlanet().getParentSolarSystem().getLocalizedName()));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Galaxy:", moon.getParentPlanet().getParentSolarSystem().getLocalizedParentGalaxyName()));
                                infoList.add(this.format(ColorUtils.stringToRGB((String)"135, 242, 230").toColoredFont() + "Parent Planet:", moon.getParentPlanet().getLocalizedName()));
                            }
                            break block23;
                        }
                        infoList.add(TextFormatting.RED + "No Basic Celestial Info");
                    }
                    catch (Exception provider) {
                        // empty catch block
                    }
                }
                for (int textSize = 0; textSize < infoList.size(); ++textSize) {
                    String text = (String)infoList.get(textSize);
                    int fontHeight = this.field_146289_q.field_78288_b + 2;
                    int y = 54 + fontHeight * textSize;
                    this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - 24, y, 0xFFFFFF);
                }
            }
        }
        this.searchField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.selectionList.func_148179_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.selectionList.func_148181_b(mouseX, mouseY, state);
        this.searchField.func_146192_a(mouseX, mouseY, state);
        if (state == 1 && mouseX >= this.searchField.field_146209_f && mouseX < this.searchField.field_146209_f + this.searchField.field_146218_h && mouseY >= this.searchField.field_146210_g && mouseY < this.searchField.field_146210_g + this.searchField.field_146219_i) {
            this.searchField.func_146180_a("");
        }
    }

    public void selectCelestial(@Nullable GuiListCelestialSelectionEntry entry) {
        this.doneButton.field_146124_l = entry != null && entry.isReachable();
    }

    private String format(String key, String value) {
        return key + " " + TextFormatting.RESET + value;
    }

    private String format(String key, boolean value) {
        return key + " " + TextFormatting.RESET + (value ? TextFormatting.GREEN : TextFormatting.RED) + value;
    }

    static enum SortType implements Comparator<CelestialBody>
    {
        A_TO_Z(1),
        Z_TO_A(2){

            @Override
            public int compare(CelestialBody celestial1, CelestialBody celestial2) {
                return celestial2.getName().compareTo(celestial1.getName());
            }
        }
        ,
        REACHALBLE(3){

            @Override
            public int compare(CelestialBody celestial1, CelestialBody celestial2) {
                return Boolean.compare(celestial2.getReachable(), celestial1.getReachable());
            }
        }
        ,
        TIER(4){

            @Override
            public int compare(CelestialBody celestial1, CelestialBody celestial2) {
                return Integer.compare(celestial2.getTierRequirement(), celestial1.getTierRequirement());
            }
        };

        protected static final SortType[] values;
        private int id;

        private SortType(int id) {
            this.id = id;
        }

        @Override
        public int compare(CelestialBody celestial1, CelestialBody celestial2) {
            return celestial1.getName().compareTo(celestial2.getName());
        }

        @Nullable
        protected static SortType getTypeForButton(GuiButton button) {
            for (SortType type : values) {
                if (type.id != button.field_146127_k) continue;
                return type;
            }
            return null;
        }

        static {
            values = SortType.values();
        }
    }
}

