/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import java.util.UUID;
import java.util.stream.Collectors;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.venus.entities.EntityJuicer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import stevekung.mods.moreplanets.core.capability.AbstractCapabilityDataMP;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.dimension.WorldProviderSpaceNether;
import stevekung.mods.moreplanets.core.event.WorldTickEventHandler;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.moons.koentus.entity.EntityKoentusMeteor;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.planets.diona.entity.EntityZeliusZombie;
import stevekung.mods.moreplanets.planets.nibiru.dimension.WorldProviderNibiru;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityInfectedZombie;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityShlime;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.BiomeGreenVeinFields;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.utils.CompatibilityManagerMP;
import stevekung.mods.moreplanets.utils.EntityEffectUtils;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.moreplanets.utils.TeleporterSpaceNether;
import stevekung.mods.moreplanets.world.IMeteorType;

public class EntityEventHandler {
    public static final DataParameter<Boolean> INFECTED_PURLONITE = new DataParameter(122, DataSerializers.field_187198_h);
    private boolean openCelestialGui;

    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            event.getEntity().func_184212_Q().func_187214_a(INFECTED_PURLONITE, (Object)false);
        }
    }

    @SubscribeEvent
    public void onZombieSummonAid(ZombieEvent.SummonAidEvent event) {
        EntityZombie zombie;
        if (event.getEntity() instanceof EntityInfectedZombie) {
            zombie = new EntityInfectedZombie(event.getWorld());
            event.setCustomSummonedAid(zombie);
            if ((double)zombie.func_70681_au().nextFloat() < zombie.func_110148_a(zombie.getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            }
            event.setResult(Event.Result.DENY);
        }
        if (event.getEntity() instanceof EntityZeliusZombie) {
            zombie = new EntityZeliusZombie(event.getWorld());
            event.setCustomSummonedAid(zombie);
            if ((double)zombie.func_70681_au().nextFloat() < zombie.func_110148_a(zombie.getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase living;
        if (!CompatibilityManagerMP.isBaubleLoaded && (living = event.getEntityLiving()) instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            if (player.field_71071_by.func_70431_c(new ItemStack(MPItems.GRAVITY_AMULET))) {
                event.setCanceled(true);
            } else {
                event.setCanceled(false);
            }
        }
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.openCelestialGui = false;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        EntityLivingBase living = event.getEntityLiving();
        World world = living.field_70170_p;
        if (living instanceof EntityPlayer) {
            player = (EntityPlayer)living;
            if (!player.field_70170_p.field_72995_K && player.field_70170_p instanceof WorldServer) {
                this.runPortalTick(player);
            }
            this.runPortalTickClient(player);
        } else if (living instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)living;
            if (player.field_70173_aa > 100 && ConfigManagerMP.moreplanets_general.enableSurvivalPlanetSelection && !WorldTickEventHandler.survivalPlanetData.hasSurvivalPlanetData && !this.openCelestialGui) {
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_OPEN_SURVIVAL_PLANET_GUI, player.field_71093_bK, new Object[0]), (EntityPlayerMP)player);
                this.openCelestialGui = true;
            }
            if (player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) || this.isInOxygen(world, player)) {
                player.func_184589_d(MPPotions.INFECTED_SPORE);
            }
            if (player.func_70644_a(MPPotions.DARK_ENERGY_PROTECTION)) {
                player.func_184589_d(MPPotions.DARK_ENERGY);
            }
            if (world.field_73011_w instanceof WorldProviderNibiru && !this.isGodPlayer(player) && !player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) && !(world.func_180494_b(player.func_180425_c()) instanceof BiomeGreenVeinFields)) {
                if (world.func_175727_C(player.func_180425_c())) {
                    player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 40));
                }
                if (player.field_70173_aa % 128 == 0 && !this.isInOxygen(world, player)) {
                    player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80));
                }
            }
            if (!world.field_72995_K && world.field_73011_w instanceof IMeteorType) {
                this.spawnMeteors(world, (EntityPlayerMP)player, (IMeteorType)world.field_73011_w);
            }
        } else if (ConfigManagerMP.moreplanets_planet_settings.enableInfectedSporeForMobs && world.field_73011_w instanceof WorldProviderNibiru && !EntityEffectUtils.isGalacticraftMob((Entity)living) && !(living instanceof EntityJuicer) && !(world.func_180494_b(living.func_180425_c()) instanceof BiomeGreenVeinFields)) {
            if (living.field_70173_aa % 128 == 0) {
                living.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 80));
            } else if (world.func_175727_C(living.func_180425_c())) {
                living.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 40));
            }
        }
        for (TileEntity tile2 : world.field_175730_i.stream().filter(tile -> tile instanceof TileEntityShieldGenerator).collect(Collectors.toList())) {
            UUID uuid;
            if (tile2.func_145831_w().field_72995_K) continue;
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile2;
            if (!(living instanceof IMob) || shield.disabled || !shield.enableShield || shield.shieldCapacity <= 0 || !shield.isInRangeOfShield(living.func_180425_c())) continue;
            if (!shield.enableDamage) {
                double d13;
                double d4 = living.func_70011_f((double)shield.func_174877_v().func_177958_n(), (double)shield.func_174877_v().func_177956_o(), (double)shield.func_174877_v().func_177952_p());
                double d6 = living.field_70165_t - (double)shield.func_174877_v().func_177958_n();
                double d8 = living.field_70163_u - (double)shield.func_174877_v().func_177956_o();
                double d10 = living.field_70161_v - (double)shield.func_174877_v().func_177952_p();
                double d11 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8 + d10 * d10));
                double d14 = d13 = (0.0 - d4) * 2.0 / 10.0;
                double knockSpeed = 10.0;
                living.field_70159_w -= (d6 /= d11) * d14 / knockSpeed;
                living.field_70181_x -= (d8 /= d11) * d14 / knockSpeed;
                living.field_70179_y -= (d10 /= d11) * d14 / knockSpeed;
            }
            try {
                uuid = UUID.fromString(shield.ownerUUID);
            }
            catch (Exception e) {
                uuid = UUID.fromString("eef3a603-1c1b-4c98-8264-d2f04b231ef4");
            }
            if (uuid != null && shield.func_145831_w().func_152378_a(uuid) != null) {
                if (living.field_70173_aa % 8 == 0 && shield.func_145831_w() instanceof WorldServer) {
                    ((WorldServer)shield.func_145831_w()).func_175739_a(EnumParticleTypes.CRIT_MAGIC, living.field_70165_t, living.field_70163_u, living.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
                }
                if (shield.enableDamage) {
                    living.func_70097_a(DamageSource.func_76365_a((EntityPlayer)shield.func_145831_w().func_152378_a(uuid)), (float)shield.shieldDamage);
                }
            } else {
                if (living.field_70173_aa % 8 == 0 && shield.func_145831_w() instanceof WorldServer) {
                    ((WorldServer)shield.func_145831_w()).func_175739_a(EnumParticleTypes.CRIT_MAGIC, living.field_70165_t, living.field_70163_u, living.field_70161_v, 20, 0.0, 0.5, 0.0, 1.0, new int[0]);
                }
                if (shield.enableDamage) {
                    living.func_70097_a(DamageSource.field_76377_j, (float)shield.shieldDamage);
                }
            }
            float motion = MathHelper.func_76133_a((double)(living.field_70159_w * living.field_70159_w + living.field_70179_y * living.field_70179_y));
            shield.shieldCapacity = (int)((float)shield.shieldCapacity - motion * 2.0f);
        }
    }

    @SubscribeEvent
    public void onOxygenSuffocation(GCCoreOxygenSuffocationEvent.Pre event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.field_70170_p.field_73011_w instanceof WorldProviderSpaceNether && EntityEffectUtils.isSpaceNetherMob((Entity)living)) {
            event.setCanceled(true);
        }
        if (living.field_70170_p.func_180494_b(living.func_180425_c()) instanceof BiomeGreenVeinFields) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getItemStack();
        Entity entity = event.getTarget();
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() == Items.field_151100_aR) {
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)(itemStack.func_77952_i() & 0xF));
            if (entity instanceof EntityShlime) {
                EntityShlime shlime = (EntityShlime)entity;
                if (!shlime.getSheared() && shlime.getFleeceColor() != color) {
                    shlime.setFleeceColor(color);
                    if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                        itemStack.func_190918_g(1);
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(EntityEvent.CanUpdate event) {
        if (event.getEntity() instanceof EntityKoentusMeteor) {
            event.setCanUpdate(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.isSpawner()) {
            return;
        }
        for (TileEntity tile2 : event.getWorld().field_175730_i.stream().filter(tile -> tile instanceof TileEntityShieldGenerator).collect(Collectors.toList())) {
            if (tile2.func_145831_w().field_72995_K) continue;
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile2;
            if (shield.disabled || !shield.isInRangeOfShield(event.getEntity().func_180425_c())) continue;
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        for (TileEntity tile2 : event.getEntityLiving().field_70170_p.field_175730_i.stream().filter(tile -> tile instanceof TileEntityShieldGenerator).collect(Collectors.toList())) {
            if (tile2.func_145831_w().field_72995_K) continue;
            TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile2;
            if (shield.disabled || !shield.isInRangeOfShield(event.getEntityLiving().func_180425_c())) continue;
            event.setCanceled(true);
        }
    }

    private void spawnMeteors(World world, EntityPlayerMP player, IMeteorType meteor) {
        if (meteor.getMeteorSpawnFrequency() > 0.0 && ConfigManagerCore.meteorSpawnMod > 0.0 && meteor.getMeteorType() != null) {
            EntityKoentusMeteor meteorEntity = null;
            int frequency = (int)(meteor.getMeteorSpawnFrequency() * 750.0 * (1.0 / ConfigManagerCore.meteorSpawnMod));
            int serverDistance = world.func_73046_m().func_184103_al().func_72395_o();
            int x = world.field_73012_v.nextInt(20) + 160;
            int z = world.field_73012_v.nextInt(20) - 10;
            double motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
            double motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
            int px = MathHelper.func_76128_c((double)player.field_70165_t);
            EntityPlayer closestPlayer = world.func_72890_a((Entity)player, 100.0);
            if (closestPlayer == null || closestPlayer.func_145782_y() <= player.func_145782_y()) {
                int size;
                if ((x + px >> 4) - (px >> 4) >= serverDistance) {
                    x = ((px >> 4) + serverDistance << 4) - 1 - px;
                }
                if (world.field_73012_v.nextInt(frequency) == 0) {
                    size = 1 + world.field_73012_v.nextInt(2);
                    switch (meteor.getMeteorType()) {
                        case KOENTUS: {
                            meteorEntity = new EntityKoentusMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, size);
                        }
                    }
                    world.func_72838_d(meteorEntity);
                    LoggerMP.debug("Spawn meteor {} at {} {} {}", EntityList.func_191301_a(meteorEntity), (int)meteorEntity.field_70165_t, (int)meteorEntity.field_70163_u, (int)meteorEntity.field_70161_v);
                }
                if (world.field_73012_v.nextInt(frequency * 3) == 0) {
                    size = 3 + world.field_73012_v.nextInt(6);
                    switch (meteor.getMeteorType()) {
                        case KOENTUS: {
                            meteorEntity = new EntityKoentusMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, size);
                        }
                    }
                    world.func_72838_d(meteorEntity);
                    LoggerMP.debug("Spawn meteor {} at {} {} {}", EntityList.func_191301_a(meteorEntity), (int)meteorEntity.field_70165_t, (int)meteorEntity.field_70163_u, (int)meteorEntity.field_70161_v);
                }
            }
        }
    }

    private boolean isInOxygen(World world, EntityPlayer player) {
        return OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v) || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player);
    }

    private boolean isGodPlayer(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || player.func_175149_v();
    }

    private void runPortalTick(EntityPlayer player) {
        AbstractCapabilityDataMP data = AbstractCapabilityDataMP.get((Entity)player);
        if (data.isInPortal()) {
            int maxTime = 80;
            data.setPortalCounter(data.getPortalCounter() + 1);
            if (data.getPortalCounter() >= maxTime) {
                data.setPortalCounter(maxTime);
                data.setTimeUntilPortal(player.func_82147_ab());
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    if (WorldTickEventHandler.survivalPlanetData != null && WorldTickEventHandler.survivalPlanetData.hasSurvivalPlanetData) {
                        int netherId = ConfigManagerMP.moreplanets_dimension.idDimensionSpaceNether;
                        String survivalPlanet = WorldTickEventHandler.survivalPlanetData.survivalPlanetName;
                        if (playerMP.field_71093_bK != netherId) {
                            playerMP.field_71133_b.func_184103_al().transferPlayerToDimension(playerMP, netherId, (Teleporter)new TeleporterSpaceNether(playerMP.field_71133_b.func_71218_a(netherId), playerMP.func_180425_c(), playerMP.field_70170_p.field_73011_w));
                            GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_RELOAD_RENDERER, playerMP.field_71093_bK, new Object[0]), playerMP);
                        } else {
                            int dimID = WorldUtil.getProviderForNameServer((String)survivalPlanet).getDimension();
                            playerMP.field_71133_b.func_184103_al().transferPlayerToDimension(playerMP, dimID, (Teleporter)new TeleporterSpaceNether(playerMP.field_71133_b.func_71218_a(dimID), playerMP.func_180425_c(), playerMP.field_70170_p.field_73011_w));
                            GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_RELOAD_RENDERER, playerMP.field_71093_bK, new Object[0]), playerMP);
                        }
                    }
                }
            }
            data.setInPortal(false);
        } else {
            if (data.getPortalCounter() > 0) {
                data.setPortalCounter(data.getPortalCounter() - 4);
            }
            if (data.getPortalCounter() < 0) {
                data.setPortalCounter(0);
            }
        }
    }

    private void runPortalTickClient(EntityPlayer player) {
        AbstractCapabilityDataMP data = AbstractCapabilityDataMP.get((Entity)player);
        data.setPrevTimeInPortal(data.getTimeInPortal());
        if (data.isInPortal()) {
            if (FMLClientHandler.instance().getClient().field_71462_r != null && !FMLClientHandler.instance().getClient().field_71462_r.func_73868_f()) {
                if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer) {
                    player.func_71053_j();
                }
                FMLClientHandler.instance().getClient().func_147108_a(null);
            }
            if (data.getTimeInPortal() == 0.0f) {
                player.func_184185_a(SoundEvents.field_187814_ei, 0.25f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
            }
            data.setTimeInPortal(data.getTimeInPortal() + 0.0125f);
            if (data.getTimeInPortal() >= 1.0f) {
                data.setTimeInPortal(1.0f);
            }
            data.setInPortal(false);
        } else {
            if (data.getTimeInPortal() > 0.0f) {
                data.setTimeInPortal(data.getTimeInPortal() - 0.05f);
            }
            if (data.getTimeInPortal() < 0.0f) {
                data.setTimeInPortal(0.0f);
            }
        }
        if (data.getTimeUntilPortal() > 0) {
            data.setTimeUntilPortal(data.getTimeUntilPortal() - 1);
        }
    }
}

