/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketRequestItem
implements IMessage {
    private int dimensionId;
    private BlockPos pos;
    private BlockPos inventoryPos;
    private ItemStack item;
    private int amount;

    public void fromBytes(ByteBuf buf) {
        this.dimensionId = buf.readInt();
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.inventoryPos = NetworkTools.readPos((ByteBuf)buf);
        this.amount = buf.readInt();
        this.item = NetworkTools.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimensionId);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.inventoryPos);
        buf.writeInt(this.amount);
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.item);
    }

    public PacketRequestItem() {
    }

    public PacketRequestItem(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketRequestItem(int dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, int amount) {
        this.dimensionId = dimensionId;
        this.pos = pos;
        this.inventoryPos = inventoryPos;
        this.item = item;
        this.amount = amount;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
            if (world == null) {
                return;
            }
            if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.pos)) {
                return;
            }
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity tileEntity = (StorageScannerTileEntity)te;
                tileEntity.requestStack(this.inventoryPos, this.item, this.amount, (EntityPlayer)ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }
}

