/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.asm.mixin.core;

import net.malisis.core.registry.Registries;
import net.malisis.core.util.callback.CallbackResult;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Chunk.class}, priority=1001)
public class MixinChunk {
    private IBlockState oldState;

    @Inject(method={"setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preSetBlock(BlockPos pos, IBlockState newState, CallbackInfoReturnable<IBlockState> cir) {
        Chunk chunk = (Chunk)this;
        this.oldState = chunk.func_177435_g(pos);
        CallbackResult<Void> cb = Registries.processPreSetBlock(chunk, pos, this.oldState, newState);
        if (cb.shouldReturn()) {
            cir.cancel();
        }
    }

    @Inject(method={"setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;"}, at={@At(value="TAIL")})
    private void postSetBlock(BlockPos pos, IBlockState newState, CallbackInfoReturnable<IBlockState> cir) {
        Registries.processPostSetBlock((Chunk)this, pos, this.oldState, newState);
    }
}

