/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.stevekunglib.core;

import java.util.Arrays;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stevekung.mods.stevekunglib.client.event.ClientEventHandler;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.CommonUtils;
import stevekung.mods.stevekunglib.utils.LoggerSL;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

@Mod(modid="stevekung's_lib", name="SteveKunG's Lib", version="1.1.7", dependencies="after:forge@[14.23.5.2847,);", updateJSON="https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/stevekung's_lib_version.json", certificateFingerprint="b3468b224a74e296555ad7efeb35f482e6f445de", acceptedMinecraftVersions="[1.12.2]")
public class SteveKunGLib {
    protected static final String NAME = "SteveKunG's Lib";
    public static final String MOD_ID = "stevekung's_lib";
    protected static final int MAJOR_VERSION = 1;
    protected static final int MINOR_VERSION = 1;
    protected static final int BUILD_VERSION = 7;
    public static final String VERSION = "1.1.7";
    protected static final String FORGE_VERSION = "after:forge@[14.23.5.2847,);";
    protected static final String JSON_URL = "https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/stevekung's_lib_version.json";
    protected static final String CERTIFICATE = "b3468b224a74e296555ad7efeb35f482e6f445de";
    private static final String URL = "https://minecraft.curseforge.com/projects/stevekungs-lib";
    public static boolean isDevelopment;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        SteveKunGLib.init(event.getModMetadata());
        CommonUtils.registerEventHandler(this);
        if (ClientUtils.isEffectiveClient()) {
            CommonUtils.registerEventHandler(new ClientEventHandler());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ClientUtils.isEffectiveClient()) {
            ColorUtils.init();
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!isDevelopment) {
            throw new RuntimeException("Invalid fingerprint detected! This version will NOT be supported by the author!");
        }
        LoggerSL.info("Development environment detected! Ignore certificate check.");
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    private static void init(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = NAME;
        info.version = VERSION;
        info.url = URL;
        info.updateJSON = JSON_URL;
        info.description = "Code and Utilities for SteveKunG's mods!";
        info.authorList = Arrays.asList("SteveKunG");
    }

    static {
        try {
            isDevelopment = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

