/*
 * Decompiled with CFR 0.152.
 */
package nc.network.render;

import io.netty.buffer.ByteBuf;
import nc.NuclearCraft;
import nc.util.NCUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class BlockHighlightUpdatePacket
implements IMessage {
    protected boolean messageValid;
    protected BlockPos pos;
    protected long highlightTimeMillis;

    public BlockHighlightUpdatePacket() {
        this.messageValid = false;
    }

    public BlockHighlightUpdatePacket(BlockPos pos, long highlightTimeMillis) {
        this.pos = pos;
        this.highlightTimeMillis = highlightTimeMillis;
        this.messageValid = true;
    }

    public void readMessage(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.highlightTimeMillis = buf.readLong();
    }

    public void writeMessage(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeLong(this.highlightTimeMillis);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.readMessage(buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        this.writeMessage(buf);
    }

    public static class Handler
    implements IMessageHandler<BlockHighlightUpdatePacket, IMessage> {
        public IMessage onMessage(BlockHighlightUpdatePacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message));
            return null;
        }

        protected void processMessage(BlockHighlightUpdatePacket message) {
            NuclearCraft.instance.blockOverlayTracker.highlightBlock(message.pos, message.highlightTimeMillis);
        }
    }
}

