/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.infos.InfoEntry;
import pregenerator.impl.storage.PregenTask;

public class CenterEntry
extends InfoEntry {
    int xCenter = 0;
    int zCenter = 0;

    public CenterEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "TaskCenter";
    }

    @Override
    public void write(IWriteableBuffer buf) {
        PregenTask task = this.getProcessor().getTask();
        if (task != null) {
            buf.writeInt(task.getCenterX());
            buf.writeInt(task.getCenterZ());
        } else {
            buf.writeInt(0);
            buf.writeInt(0);
        }
    }

    @Override
    public void read(IReadableBuffer buf) {
        this.xCenter = buf.readInt();
        this.zCenter = buf.readInt();
    }

    @Override
    public int currentValue() {
        return 0;
    }

    @Override
    public int maxValue() {
        return 0;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        int wid = width - 25;
        helper.renderText(x - wid, y, width, "CenterPos: X: " + this.xCenter + ", Z: " + this.zCenter);
    }
}

