/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IConverterExcludeMethod;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IMethodRegistry;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.MethodCollection;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.capabilities.DefaultCostHandler;
import org.squiddev.plethora.core.collections.ClassIteratorIterable;

public final class MethodRegistry
implements IMethodRegistry {
    public static final MethodRegistry instance = new MethodRegistry();
    final Multimap<Class<?>, IMethod<?>> providers = MultimapBuilder.hashKeys().arrayListValues().build();

    public <T> void registerMethod(@Nonnull Class<T> target, @Nonnull IMethod<T> method) {
        Objects.requireNonNull(target, "target cannot be null");
        Objects.requireNonNull(method, "method cannot be null");
        String comment = method.getName() + ": " + method.getDocString();
        String id = method.getId();
        if (id.indexOf(35) >= 0) {
            String oldId = id.replace('#', '$');
            int targetIdx = oldId.lastIndexOf(40);
            if (targetIdx >= 0) {
                oldId = oldId.substring(0, targetIdx);
            }
            ConfigCore.configuration.renameProperty("baseCosts", oldId, id);
        }
        ConfigCore.configuration.get("baseCosts", method.getId(), 0, comment, 0, Integer.MAX_VALUE);
        this.providers.put(target, method);
        if (target == Object.class && !(method instanceof IConverterExcludeMethod)) {
            PlethoraCore.LOG.warn("You're registering a method (" + method + ") targeting the base class (Object). Converters will probably mask the original object: it is recommended that you implement IConverterExcludeMethod to avoid this.");
        }
    }

    @Override
    @Nonnull
    public <T> List<IMethod<T>> getMethods(@Nonnull IPartialContext<T> context) {
        Objects.requireNonNull(context, "context cannot be null");
        ArrayList methods = Lists.newArrayList();
        for (IMethod<?> genMethod : this.getMethods(context.getTarget().getClass())) {
            IMethod<?> method = genMethod;
            if (!method.canApply(context)) continue;
            methods.add(method);
        }
        return Collections.unmodifiableList(methods);
    }

    @Override
    @Nonnull
    public List<IMethod<?>> getMethods(@Nonnull Class<?> target) {
        Objects.requireNonNull(target, "target cannot be null");
        ArrayList result = Lists.newArrayList();
        for (Class<?> klass : new ClassIteratorIterable(target)) {
            result.addAll(this.providers.get(klass));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    @Nonnull
    public ICostHandler getCostHandler(@Nonnull ICapabilityProvider object, @Nullable EnumFacing side) {
        Objects.requireNonNull(object, "object cannot be null");
        ICostHandler handler = (ICostHandler)object.getCapability(Constants.COST_HANDLER_CAPABILITY, side);
        return handler != null ? handler : DefaultCostHandler.get(object);
    }

    @Override
    public int getBaseMethodCost(IMethod<?> method) {
        Property property = ConfigCore.baseCosts.get(method.getId());
        if (property == null) {
            PlethoraCore.LOG.warn("Cannot find cost for " + method.getId() + ", this may have been registered incorrectly");
            return 0;
        }
        return property.getInt();
    }

    public Pair<List<IMethod<?>>, List<UnbakedContext<?>>> getMethodsPaired(Context<?> builder) {
        int index;
        Integer existing;
        ArrayList methods = Lists.newArrayList();
        ArrayList contexts = Lists.newArrayList();
        HashMap<String, Integer> methodLookup = new HashMap<String, Integer>();
        String[] keys = builder.keys;
        Object[] values = builder.values;
        for (int i = values.length - 1; i >= 0; --i) {
            if (!"target".equals(keys[i])) continue;
            UnbakedContext<?> unbaked = null;
            for (IMethod method : this.getMethods(builder.withIndex(i))) {
                if (i != builder.target && method instanceof IConverterExcludeMethod) continue;
                if (unbaked == null) {
                    unbaked = ((UnbakedContext)builder.unbake()).withIndex(i);
                }
                if ((existing = (Integer)methodLookup.get(method.getName())) != null) {
                    index = existing;
                    if (method.getPriority() <= ((IMethod)methods.get(index)).getPriority()) continue;
                    methods.set(index, method);
                    contexts.set(index, unbaked);
                    continue;
                }
                methods.add(method);
                contexts.add(unbaked);
                methodLookup.put(method.getName(), methods.size() - 1);
            }
        }
        if (!methods.isEmpty()) {
            MethodCollection collection = new MethodCollection(methods);
            IContext baked = builder.makeChildId(collection);
            for (IMethod method : this.getMethods(baked)) {
                existing = (Integer)methodLookup.get(method.getName());
                if (existing != null) {
                    index = existing;
                    if (method.getPriority() <= ((IMethod)methods.get(index)).getPriority()) continue;
                    methods.set(index, method);
                    contexts.set(index, ((Context)baked).unbake());
                    continue;
                }
                methods.add(method);
                contexts.add(((Context)baked).unbake());
                methodLookup.put(method.getName(), methods.size() - 1);
            }
        }
        return Pair.of((Object)methods, (Object)contexts);
    }
}

