/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public final class EquipmentInvWrapper
implements IItemHandlerModifiable {
    private static final EntityEquipmentSlot[] VALUES = EntityEquipmentSlot.values();
    private static final int SLOTS = VALUES.length;
    private final EntityLivingBase entity;

    public EquipmentInvWrapper(EntityLivingBase entity) {
        this.entity = entity;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        EquipmentInvWrapper.validateSlotIndex(slot);
        this.entity.func_184201_a(VALUES[slot], stack);
    }

    public int getSlots() {
        return SLOTS;
    }

    public ItemStack getStackInSlot(int slot) {
        EquipmentInvWrapper.validateSlotIndex(slot);
        return this.entity.func_184582_a(VALUES[slot]);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!stack.func_190926_b()) {
            boolean reachedLimit;
            EquipmentInvWrapper.validateSlotIndex(slot);
            EntityEquipmentSlot slotType = VALUES[slot];
            if (slotType.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && !stack.func_77973_b().isValidArmor(stack, slotType, (Entity)this.entity)) {
                return stack;
            }
            ItemStack existing = this.getStackInSlot(slot);
            int limit = stack.func_77976_d();
            if (!existing.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.func_190916_E();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.func_190916_E() > limit;
            if (!simulate) {
                if (existing.func_190926_b()) {
                    this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                } else {
                    existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                }
                this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        EquipmentInvWrapper.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    private static void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= SLOTS) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0, " + SLOTS + "]");
        }
    }

    private void onContentsChanged(int slot) {
        if (this.entity instanceof EntityLiving) {
            ((EntityLiving)this.entity).func_184642_a(VALUES[slot], 1.1f);
        } else if (this.entity instanceof EntityPlayer) {
            ((EntityPlayer)this.entity).field_71071_by.func_70296_d();
        }
    }
}

