/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.trades.builder;

import ic2.api.classic.trading.trades.IItemTrade;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.trades.items.BasicCustomItemTrade;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ItemTradeFabricator {
    Map<Integer, NonNullList<ItemStack>> inputs = new HashMap<Integer, NonNullList<ItemStack>>();
    Map<Integer, NonNullList<ItemStack>> outputs = new HashMap<Integer, NonNullList<ItemStack>>();
    Map<Integer, ItemTradeRules> rules = new HashMap<Integer, ItemTradeRules>();
    Set<Integer> slots = new HashSet<Integer>();

    public void setItems(PersonalInventory inv, int slot) {
        NonNullList input = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        NonNullList output = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        boolean hasAnything = false;
        for (int i = 0; i < 8; ++i) {
            input.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
            output.set(i, (Object)inv.getStackInSlot(i + 8).func_77946_l());
            if (hasAnything) continue;
            hasAnything = !((ItemStack)input.get(i)).func_190926_b() || !((ItemStack)output.get(i)).func_190926_b();
        }
        if (hasAnything) {
            this.inputs.put(slot, (NonNullList<ItemStack>)input);
            this.outputs.put(slot, (NonNullList<ItemStack>)output);
            this.slots.add(slot);
        } else {
            this.inputs.remove(slot);
            this.outputs.remove(slot);
            this.slots.remove(slot);
        }
    }

    public boolean hasKey(int slot) {
        return this.slots.contains(slot);
    }

    public void pushToSlots(int slot, PersonalInventory inv) {
        NonNullList in = this.inputs.get(slot);
        NonNullList out = this.outputs.get(slot);
        if (in == null || in.size() != 8) {
            in = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        }
        if (out == null || out.size() != 8) {
            out = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        }
        for (int i = 0; i < 8; ++i) {
            inv.setStackInSlot(i, ((ItemStack)in.get(i)).func_77946_l());
            inv.setStackInSlot(8 + i, ((ItemStack)out.get(i)).func_77946_l());
        }
    }

    public void setItems(int slot, PersonalInventory inv, boolean copyInput, boolean copyOutput) {
        NonNullList input = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        NonNullList output = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 8; ++i) {
            if (copyInput) {
                input.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
            }
            if (!copyOutput) continue;
            output.set(i, (Object)inv.getStackInSlot(i + 8).func_77946_l());
        }
        this.inputs.put(slot, (NonNullList<ItemStack>)input);
        this.outputs.put(slot, (NonNullList<ItemStack>)output);
    }

    public void removeInput(int slot) {
        this.inputs.remove(slot);
    }

    public void clear() {
        this.inputs.clear();
        this.outputs.clear();
        this.rules.clear();
        this.slots.clear();
    }

    public IItemTrade createTrade(UUID owner) {
        BasicCustomItemTrade custom = new BasicCustomItemTrade(owner);
        for (Integer slot : this.slots) {
            custom.addSlot(slot, this.inputs.get(slot), this.outputs.get(slot));
            custom.addRules(slot, this.getRules(slot));
        }
        custom.createSubTrades();
        return custom;
    }

    public ItemTradeRules getRules(int slot) {
        ItemTradeRules newRules = this.rules.get(slot);
        if (newRules == null) {
            newRules = new ItemTradeRules();
            this.rules.put(slot, newRules);
        }
        return newRules;
    }

    public static class ItemTradeRules {
        public boolean creative;
        public boolean money;
        public boolean waitingAfterBuy;
        public boolean tradeLimit;
        public boolean ignoreNBT;
        public boolean useOreDictionary;
        public int moneyNeeded = 1;
        public int waitingTime = 20;
        public int limitPerPlayer = 1;

        public NBTTagCompound save() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("creative", this.creative);
            nbt.func_74757_a("money", this.money);
            nbt.func_74757_a("waiting", this.waitingAfterBuy);
            nbt.func_74757_a("Trade", this.tradeLimit);
            nbt.func_74757_a("IgnoreNBT", this.ignoreNBT);
            nbt.func_74757_a("UseOreDict", this.useOreDictionary);
            nbt.func_74768_a("Needs", this.moneyNeeded);
            nbt.func_74768_a("Time", this.waitingTime);
            nbt.func_74768_a("Limit", this.limitPerPlayer);
            return nbt;
        }

        public void load(NBTTagCompound nbt) {
            this.creative = nbt.func_74767_n("creative");
            this.money = nbt.func_74767_n("money");
            this.waitingAfterBuy = nbt.func_74767_n("waiting");
            this.tradeLimit = nbt.func_74767_n("Trade");
            this.ignoreNBT = nbt.func_74767_n("IgnoreNBT");
            this.useOreDictionary = nbt.func_74767_n("UseOreDict");
            this.moneyNeeded = nbt.func_74762_e("Needs");
            this.waitingTime = nbt.func_74762_e("Time");
            this.limitPerPlayer = nbt.func_74762_e("Limit");
        }
    }
}

