/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.helpers;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.core.block.misc.tile.TileEntityTexturedWall;
import ic2.core.block.resources.BlockRubberLeaves;
import ic2.core.block.wiring.tile.TileEntityCable;
import ic2.core.block.wiring.tile.TileEntityLuminator;
import ic2.core.item.armor.electric.ItemArmorQuantumSuit;
import ic2.core.item.crop.ItemCropSeed;
import ic2.core.item.misc.ItemDisplayIcon;
import ic2.core.item.tool.electric.ItemElectricToolObscurator;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IC2Colors
implements IBlockColor,
IItemColor {
    public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        if (state == null) {
            return -1;
        }
        if (state.func_177230_c() instanceof BlockRubberLeaves) {
            return ColorizerFoliage.func_77469_b();
        }
        if (pos == null || world == null) {
            return -1;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator lumi = (TileEntityLuminator)tile;
            if (tintIndex == 100) {
                return lumi.color == IEnergyConductorColored.WireColor.Blank ? -1 : ItemDye.field_150922_c[lumi.color.toColor().func_176767_b()];
            }
            IBlockState glass = lumi.getGlassAsBlock();
            if (glass == null) {
                return -1;
            }
            int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(glass, null, null, tintIndex);
            if (color == -1 && glass.func_177230_c() instanceof BlockStainedGlass) {
                EnumDyeColor dyeColor = (EnumDyeColor)glass.func_177229_b((IProperty)BlockStainedGlass.field_176547_a);
                return ItemDye.field_150922_c[dyeColor.func_176767_b()];
            }
            return color;
        }
        if (tile instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tile;
            int dir = tintIndex / 50;
            int index = tintIndex % 50;
            int[] colors = cable.getStorage().getEntry(dir).getColorMultiplier();
            if (index >= colors.length) {
                return -1;
            }
            return colors[index];
        }
        if (tile instanceof TileEntityTexturedWall) {
            TileEntityTexturedWall wall = (TileEntityTexturedWall)tile;
            int dir = tintIndex / 50;
            int index = tintIndex % 50;
            int[] colors = wall.getStorage().getEntry(dir).getColorMultiplier();
            if (index >= colors.length) {
                return -1;
            }
            return colors[index];
        }
        return -1;
    }

    public int func_186726_a(ItemStack stack, int tintIndex) {
        ItemStack entry;
        FluidStack fluid;
        if (stack.func_190926_b()) {
            return -1;
        }
        if (StackUtil.isStackEqual(stack, Ic2Items.rubberLeaves)) {
            return ColorizerFoliage.func_77469_b();
        }
        if (StackUtil.isStackEqual(stack, Ic2Items.obscurator)) {
            ItemElectricToolObscurator obs = (ItemElectricToolObscurator)stack.func_77973_b();
            int[] colors = obs.getColors(stack);
            if (colors.length > tintIndex) {
                return colors[tintIndex];
            }
            return 10511680;
        }
        if (stack.func_77973_b() instanceof ItemArmorQuantumSuit) {
            ItemArmorQuantumSuit suit = (ItemArmorQuantumSuit)stack.func_77973_b();
            if (suit.func_82816_b_(stack)) {
                return suit.func_82814_b(stack);
            }
            return -1;
        }
        if (StackUtil.isStackEqual(stack, Ic2Items.fluidDisplay) && (fluid = ItemDisplayIcon.getFluidStack(stack)) != null) {
            return fluid.getFluid().getColor(fluid);
        }
        if (stack.func_77973_b() == Ic2Items.cropSeed.func_77973_b() && !(entry = ItemCropSeed.getDisplayItem(stack)).func_190926_b()) {
            return Minecraft.func_71410_x().getItemColors().func_186728_a(entry, tintIndex);
        }
        return -1;
    }
}

