/*
 * Decompiled with CFR 0.152.
 */
package net.rom.gctweaks;

import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.rom.gctweaks.ModuleController;
import net.rom.gctweaks.base.InternalModule;
import net.rom.gctweaks.base.Module;
import net.rom.gctweaks.base.core.proxy.CommonProxy;
import net.rom.gctweaks.base.core.utils.GameUtil;
import net.rom.gctweaks.base.core.utils.I18nHelper;
import net.rom.gctweaks.base.core.utils.LogHelper;

@Mod(modid="gctweaks", name="GalacticTweaks", version="1.2.0", dependencies="required:forge@[14.23.5.2847,);required-after:galacticraftcore@[4.0.2.261,];required-after:galacticraftplanets;;after:asmodeuscore@[0.0.17,];after:extraplanets;after:galaxyspace;after:zollerngalaxy;after:moreplanets;", certificateFingerprint="9849375f22c1477466799effce3d8a566ae781cf", useMetadata=true, acceptedMinecraftVersions="[1.12.2]")
public class GalacticTweaks {
    @Mod.Instance(value="gctweaks")
    public static GalacticTweaks instance;
    public static SimpleNetworkWrapper network;
    public static LogHelper logger;
    public static I18nHelper stringz;
    @SidedProxy(clientSide="net.rom.gctweaks.base.core.proxy.ClientProxy", serverSide="net.rom.gctweaks.base.core.proxy.CommonProxy")
    public static CommonProxy proxy;

    @NetworkCheckHandler
    public boolean networkCheck(Map<String, String> map, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!GameUtil.isDeobfuscated()) {
            logger.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
        } else {
            logger.info("Ignoring fingerprint signing since we are in a Development Enviroment");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModuleController.registerInternalModules();
        ModuleController.internals.forEach(module -> module.registerPacket(network));
        ModuleController.internals.forEach(InternalModule::preInit);
        ModuleController.registerModules();
        ModuleController.modules.forEach(module -> module.setupConfig(event));
        ModuleController.modules.forEach(Module::syncConfig);
        ModuleController.modules.forEach(module -> module.registerPacket(network));
        ModuleController.modules.forEach(Module::preInit);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModuleController.internals.forEach(InternalModule::init);
        ModuleController.modules.forEach(Module::init);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModuleController.internals.forEach(InternalModule::postInit);
        ModuleController.modules.forEach(Module::postInit);
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        ModuleController.internals.forEach(internal -> internal.serverStartingEvent(event));
        ModuleController.modules.forEach(module -> module.serverStartingEvent(event));
    }

    static {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("gctweaks");
        logger = new LogHelper();
        stringz = new I18nHelper("gctweaks", logger, false);
    }
}

