/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.entries.BlockClassEntry;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockSimpleDecorative
extends XUBlockStatic {
    public static final PropertyEnumSimple<Type> TYPE = new PropertyEnumSimple<Type>(Type.class);

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addDropProperties(new IProperty[]{TYPE}).build();
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        return BoxModel.newStandardBlock(((Type)((Object)state.func_177229_b(BlockSimpleDecorative.TYPE))).texture);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 0.0f;
        }
        Type value = (Type)((Object)state.func_177229_b(TYPE));
        return value.getEnchantBonus();
    }

    public static enum Type implements IItemStackMaker
    {
        BLOCK_ENCHANTED("blockEnchantedMetal", "enchanted_block"){

            @Override
            public void addRecipes() {
            }

            @Override
            public float getEnchantBonus() {
                return 5.0f;
            }
        }
        ,
        BLOCK_DEMONIC("blockDemonicMetal", "demon_block"){

            @Override
            public void addRecipes() {
            }
        }
        ,
        BLOCK_EVIL("blockEvilMetal", "evil_infused_ingot_block"){

            @Override
            public void addRecipes() {
            }
        };

        public final String oreName;
        public final String texture;

        private Type(String oreName, String texture) {
            this.oreName = oreName;
            this.texture = texture;
        }

        public abstract void addRecipes();

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }

        @Override
        public ItemStack newStack(int num) {
            BlockClassEntry<BlockSimpleDecorative> simpleDecorative = XU2Entries.simpleDecorative;
            return simpleDecorative.newStack(num, ((BlockSimpleDecorative)simpleDecorative.value).func_176223_P().func_177226_a(TYPE, (Comparable)((Object)this)));
        }

        public float getEnchantBonus() {
            return 0.0f;
        }
    }
}

