/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.client;

import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import noppes.vc.CommonProxy;
import noppes.vc.EntityProjectile;
import noppes.vc.VCArmors;
import noppes.vc.VCBlocks;
import noppes.vc.VCItems;
import noppes.vc.VCWeapons;
import noppes.vc.VariedCommodities;
import noppes.vc.client.FontContainer;
import noppes.vc.client.ModelSkirtArmor;
import noppes.vc.client.PacketHandlerClient;
import noppes.vc.client.VCResourceLoader;
import noppes.vc.client.fx.EntityElementalStaffFX;
import noppes.vc.client.gui.GuiBigSign;
import noppes.vc.client.gui.GuiCarpentryBench;
import noppes.vc.client.gui.GuiCrate;
import noppes.vc.client.gui.GuiRecipes;
import noppes.vc.client.gui.GuiTradingBlock;
import noppes.vc.client.renderer.RenderProjectile;
import noppes.vc.constants.GuiType;
import noppes.vc.containers.ContainerCarpentryBench;
import noppes.vc.containers.ContainerCrate;
import noppes.vc.containers.ContainerTradingBlock;

public class ClientProxy
extends CommonProxy {
    public static FontContainer Font = null;
    private ModelSkirtArmor model = new ModelSkirtArmor();

    @Override
    public void preinit() {
        super.preinit();
        Font = new FontContainer("Default", 18);
        VariedCommodities.Channel.register((Object)new PacketHandlerClient());
    }

    @Override
    public void init() {
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectile.class, (Render)new RenderProjectile());
    }

    @Override
    public void postinit() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new VCResourceLoader());
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                float[] color = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176766_a((int)stack.func_77952_i()));
                return new Color(color[0], color[1], color[2]).getRGB();
            }
        }, new Item[]{VCWeapons.elemental_staff, VCItems.orb, VCItems.orb_broken, Item.func_150898_a((Block)VCBlocks.crystal)});
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex > 0 ? -1 : ((ItemArmor)stack.func_77973_b()).func_82814_b(stack);
            }
        }, new Item[]{VCItems.paper_crown, VCArmors.leather_skirt});
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                return state.func_185909_g((IBlockAccess)world, (BlockPos)pos).field_76291_p;
            }
        }, new Block[]{VCBlocks.crystal});
    }

    @Override
    public ModelBiped getSkirtModel() {
        return this.model;
    }

    @Override
    public void spawnParticle(EntityLivingBase player, String string, Object ... ob) {
        if (string.equals("Spell")) {
            int color = (Integer)ob[0];
            int number = (Integer)ob[1];
            for (int i = 0; i < number; ++i) {
                Random rand = player.func_70681_au();
                double x = (rand.nextDouble() - 0.5) * (double)player.field_70130_N;
                double y = player.func_70047_e();
                double z = (rand.nextDouble() - 0.5) * (double)player.field_70130_N;
                double f = (rand.nextDouble() - 0.5) * 2.0;
                double f1 = -rand.nextDouble();
                double f2 = (rand.nextDouble() - 0.5) * 2.0;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new EntityElementalStaffFX(player, x, y, z, f, f1, f2, color));
            }
        } else if (string.equals("Block")) {
            BlockPos pos = (BlockPos)ob[0];
            int id = (Integer)ob[1];
            Block block = Block.func_149729_e((int)(id & 0xFFF));
            Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, block.func_176203_a(id >> 12 & 0xFF));
        }
    }

    @Override
    public void spawnParticle(EnumParticleTypes particle, double x, double y, double z, double motionX, double motionY, double motionZ, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        double xx = mc.func_175606_aa().field_70165_t - x;
        double yy = mc.func_175606_aa().field_70163_u - y;
        double zz = mc.func_175606_aa().field_70161_v - z;
        if (xx * xx + yy * yy + zz * zz > 256.0) {
            return;
        }
        Particle fx = mc.field_71452_i.func_178927_a(particle.func_179348_c(), x, y, z, motionX, motionY, motionZ, new int[0]);
        if (fx == null) {
            return;
        }
        if (particle == EnumParticleTypes.FLAME) {
            ObfuscationReflectionHelper.setPrivateValue(ParticleFlame.class, (Object)((ParticleFlame)fx), (Object)Float.valueOf(scale), (int)0);
        } else if (particle == EnumParticleTypes.SMOKE_NORMAL) {
            ObfuscationReflectionHelper.setPrivateValue(ParticleSmokeNormal.class, (Object)((ParticleSmokeNormal)fx), (Object)Float.valueOf(scale), (int)0);
        }
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID > GuiType.values().length) {
            return null;
        }
        GuiType gui = GuiType.values()[ID];
        Container container = this.getContainer(gui, player, world, x, y, z);
        return this.getGui(gui, container, x, y, z);
    }

    private GuiScreen getGui(GuiType gui, Container container, int x, int y, int z) {
        if (gui == GuiType.TRADING_BLOCK) {
            return new GuiTradingBlock((ContainerTradingBlock)container);
        }
        if (gui == GuiType.CRATE) {
            return new GuiCrate((ContainerCrate)container);
        }
        if (gui == GuiType.CARPENTRY_BENCH) {
            return new GuiCarpentryBench((ContainerCarpentryBench)container);
        }
        if (gui == GuiType.BIG_SIGN) {
            return new GuiBigSign(x, y, z);
        }
        if (gui == GuiType.VCRECIPES) {
            return new GuiRecipes();
        }
        return null;
    }

    @Override
    public void openGui(GuiType gui, int x, int y, int z) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Container container = this.getContainer(gui, (EntityPlayer)minecraft.field_71439_g, (World)minecraft.field_71441_e, x, y, z);
        GuiScreen guiscreen = this.getGui(gui, container, x, y, z);
        if (guiscreen != null) {
            minecraft.func_147108_a(guiscreen);
        }
    }

    @Override
    public void openGui(EntityPlayer player, Object guiscreen) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!player.field_70170_p.field_72995_K || !(guiscreen instanceof GuiScreen)) {
            return;
        }
        if (guiscreen != null) {
            minecraft.func_147108_a((GuiScreen)guiscreen);
        }
    }
}

